/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.iface;

import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface ISwitchable {
    public static boolean isMode(ItemStack stack, String funcName) {
        if (!stack.m_41698_("mode").m_128441_(funcName)) {
            return false;
        }
        return stack.m_41698_("mode").m_128471_(funcName);
    }

    default public boolean isActive(ItemStack stack, String funcName) {
        return ISwitchable.isMode(stack, funcName);
    }

    public static int getCurrentMode(ItemStack stack, List<String> modeList) {
        CompoundTag modeTag = stack.m_41698_("mode");
        for (int i = 0; i < modeList.size(); ++i) {
            String mode = modeList.get(i);
            if (!modeTag.m_128441_(mode) || !modeTag.m_128471_(mode)) continue;
            return i;
        }
        return -1;
    }

    default public int getCurrentModeIndex(ItemStack stack, List<String> modeList) {
        return ISwitchable.getCurrentMode(stack, modeList);
    }

    default public void setMode(ItemStack stack, List<String> modeList, int modeIndex) {
        CompoundTag modeTag = stack.m_41698_("mode");
        for (String mode : modeList) {
            modeTag.m_128379_(mode, false);
        }
        if (modeIndex >= 0 && modeIndex < modeList.size()) {
            modeTag.m_128379_(modeList.get(modeIndex), true);
        }
    }

    default public void cycleMode(@NotNull Level world, Player player, @NotNull InteractionHand hand, List<String> modeList) {
        if (modeList.isEmpty()) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        int currentIndex = this.getCurrentModeIndex(stack, modeList);
        int nextIndex = (currentIndex + 1) % modeList.size();
        this.setMode(stack, modeList, nextIndex);
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String nextMode = modeList.get(nextIndex);
            MutableComponent modeTooltip = Component.m_237115_((String)("tooltip.avaritia.tool." + nextMode));
            serverPlayer.m_240418_((Component)ModTooltips.ACTIVE.args(modeTooltip).build(), true);
        }
        player.m_6674_(hand);
    }

    default public void switchToMode(@NotNull Level world, Player player, @NotNull InteractionHand hand, List<String> modeList, String modeName) {
        if (!modeList.contains(modeName)) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        CompoundTag modeTag = stack.m_41698_("mode");
        for (String mode : modeList) {
            modeTag.m_128379_(mode, false);
        }
        modeTag.m_128379_(modeName, true);
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent modeTooltip = Component.m_237115_((String)("tooltip.avaritia.tool." + modeName));
            serverPlayer.m_240418_((Component)ModTooltips.ACTIVE.args(modeTooltip).build(), true);
        }
        player.m_6674_(hand);
    }

    default public void switchMode(@NotNull Level world, Player player, @NotNull InteractionHand hand, String funcName) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tags = stack.m_41698_("mode");
        MutableComponent funcTooltip = Component.m_237115_((String)("tooltip.avaritia.tool." + funcName));
        tags.m_128379_(funcName, !tags.m_128471_(funcName));
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_240418_((Component)(tags.m_128471_(funcName) ? ModTooltips.ACTIVE.args(funcTooltip).build() : ModTooltips.INACTIVE.args(funcTooltip).build()), true);
        }
        player.m_6674_(hand);
    }
}

