/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.init.registry;

import committee.nova.mods.avaritia.api.common.item.BaseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class RegUtils {
    public static DeferredRegister<Block> BLOCKS;
    public static DeferredRegister<Item> ITEMS;
    public static DeferredRegister<CreativeModeTab> TABS;
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    public static DeferredRegister<EntityType<?>> ENTITIES;
    public static DeferredRegister<MenuType<?>> MENUS;
    public static DeferredRegister<Enchantment> ENCHANTMENT;
    public static DeferredRegister<RecipeType<?>> RECIPES;
    public static DeferredRegister<RecipeSerializer<?>> SERIALIZERS;
    public static final List<RegistryObject<Item>> ACCEPT_ITEM;

    public static void init(String modid, IEventBus bus) {
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
        TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)modid);
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)modid);
        MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)modid);
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)modid);
        ENCHANTMENT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)modid);
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)modid);
        SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)modid);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TABS.register(bus);
        BLOCK_ENTITIES.register(bus);
        MENUS.register(bus);
        ENTITIES.register(bus);
        ENCHANTMENT.register(bus);
        RECIPES.register(bus);
        SERIALIZERS.register(bus);
    }

    public static RegistryObject<Item> item(String name) {
        return RegUtils.item(name, true);
    }

    public static RegistryObject<Item> item(String name, boolean exist) {
        return RegUtils.item(name, (String e) -> new BaseItem(), exist);
    }

    public static RegistryObject<Item> item(String name, Function<String, Item> item) {
        return RegUtils.item(name, item, true);
    }

    public static RegistryObject<Item> item(String name, Function<String, Item> item, boolean exist) {
        return RegUtils.item(name, () -> (Item)item.apply(name), exist);
    }

    public static RegistryObject<Item> item(String name, Supplier<Item> item) {
        return RegUtils.item(name, item, true);
    }

    public static RegistryObject<Item> item(String name, Supplier<Item> item, boolean exist) {
        RegistryObject regItem = ITEMS.register(name, item);
        if (exist) {
            ACCEPT_ITEM.add((RegistryObject<Item>)regItem);
        }
        return regItem;
    }

    private static RegistryObject<Block> baseBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block) {
        return RegUtils.itemBlock(name, block, true);
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem) {
        return RegUtils.itemBlock(name, block, hasItem, true, new Item.Properties());
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, boolean exist) {
        return RegUtils.itemBlock(name, block, hasItem, exist, new Item.Properties());
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, Rarity rarity) {
        return RegUtils.itemBlock(name, block, true, true, new Item.Properties().m_41497_(rarity));
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, Item.Properties properties) {
        return RegUtils.itemBlock(name, block, hasItem, true, properties);
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, boolean exist, Item.Properties properties) {
        RegistryObject reg = BLOCKS.register(name, block);
        if (hasItem) {
            RegUtils.item(name, () -> new BlockItem((Block)reg.get(), properties), exist);
        }
        return reg;
    }

    public static RegistryObject<Block> itemBurnBlock(String name, Supplier<Block> block, boolean hasItem, Item.Properties properties, final int burnTime) {
        RegistryObject reg = BLOCKS.register(name, block);
        if (hasItem) {
            RegUtils.item(name, () -> new BlockItem((Block)reg.get(), properties){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return burnTime;
                }
            });
        }
        return reg;
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> blockEntity(String name, BlockEntityType.BlockEntitySupplier<T> tile, Supplier<Block[]> blocks) {
        return BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)tile, (Block[])((Block[])blocks.get())).m_58966_(null));
    }

    public static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> menu(String name, IContainerFactory<T> container) {
        return MENUS.register(name, () -> IForgeMenuType.create((IContainerFactory)container));
    }

    public static RegistryObject<Enchantment> enchant(String name, Supplier<Enchantment> enchantment) {
        return ENCHANTMENT.register(name, enchantment);
    }

    public static <T extends Recipe<Container>> RegistryObject<RecipeType<T>> recipe(String name, Supplier<RecipeType<T>> type) {
        return RECIPES.register(name, type);
    }

    public static RegistryObject<RecipeSerializer<?>> serializer(String name, Supplier<RecipeSerializer<?>> serializer) {
        return SERIALIZERS.register(name, serializer);
    }

    static {
        ACCEPT_ITEM = new ArrayList<RegistryObject<Item>>();
    }
}

