/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import committee.nova.mods.avaritia.Const;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class InventoryUtils {
    public static ItemStack tryInsert(ItemStack itemInv, ItemStack stack) {
        AtomicReference<ItemStack> returnStack = new AtomicReference<ItemStack>(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41613_()));
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> returnStack.set(ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false)));
        return returnStack.get();
    }

    public static ItemStack tryFilteredInsert(ItemStack itemInv, ItemStack stack) {
        if (itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && InventoryUtils.itemInvHasItem(itemInv, stack)) {
            return InventoryUtils.tryInsert(itemInv, stack);
        }
        return stack;
    }

    private static boolean itemInvHasItem(ItemStack itemInv, ItemStack stack) {
        AtomicBoolean hasItem = new AtomicBoolean(false);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                hasItem.set(true);
            }
        });
        return hasItem.get();
    }

    public static ItemStack findFirstItem(Player player, Item consumeFrom) {
        return player.m_150109_().f_35974_.stream().filter(s -> !s.m_41619_() && s.m_41720_() == consumeFrom).findFirst().orElse(ItemStack.f_41583_);
    }

    public static int getFirstSlotWithStack(ItemStack itemInv, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    private static int getLastSlotWithStack(ItemStack itemInv, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = h.getSlots() - 1; i >= 0; --i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    public static List<Integer> getAllSlotsWithStack(Player player, Predicate<ItemStack> action) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!action.test(player.m_150109_().m_8020_(i))) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack findItemInInv(Player player, Predicate<ItemStack> is) {
        if (is.test(player.m_21205_())) {
            return player.m_21205_();
        }
        if (is.test(player.m_21206_())) {
            return player.m_21206_();
        }
        Inventory inv = player.m_150109_();
        int size = inv.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack s = inv.m_8020_(i);
            if (!is.test(s)) continue;
            return s;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack findItemInInv(Player player, Predicate<ItemStack> is, Function<ItemStack, ItemStack> map) {
        if (Const.curios) {
            AtomicReference s = new AtomicReference(new ArrayList());
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> s.set(curiosInventory.findCurios(is)));
            if (!((List)s.get()).isEmpty()) {
                return map.apply(((SlotResult)((List)s.get()).get(0)).stack());
            }
        }
        if (is.test(player.m_21205_())) {
            return map.apply(player.m_21205_());
        }
        if (is.test(player.m_21206_())) {
            return map.apply(player.m_21206_());
        }
        Inventory inv = player.m_150109_();
        int size = inv.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack s = inv.m_8020_(i);
            if (!is.test(s)) continue;
            return map.apply(s);
        }
        return ItemStack.f_41583_;
    }

    public static ICapabilityProvider createCurioProvider(final ItemStack stack, CompoundTag unused) {
        if (Const.curios) {
            return CuriosApi.createCurioProvider((ICurio)new ICurio(){

                public ItemStack getStack() {
                    return stack;
                }

                public void curioTick(SlotContext slotContext) {
                    LivingEntity entity = slotContext.entity();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (!player.m_9236_().f_46443_) {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, -1, 2, false, true));
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 2, false, true));
                            ArrayList effects = Lists.newArrayList((Iterable)player.m_21220_());
                            for (MobEffectInstance potion2 : Collections2.filter((Collection)effects, potion -> potion.m_19544_().equals(MobEffects.f_19597_) || potion.m_19544_().equals(MobEffects.f_19599_))) {
                                player.m_21195_(potion2.m_19544_());
                            }
                        }
                    }
                }

                public boolean canEquip(SlotContext slotContext) {
                    return true;
                }

                public boolean canUnequip(SlotContext slotContext) {
                    return true;
                }
            });
        }
        return null;
    }
}

