/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.util.NBTUtils;
import committee.nova.mods.avaritia.api.util.vec.Vector3;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static String getId(Item item) {
        ResourceLocation resource = ForgeRegistries.ITEMS.getKey((Object)item);
        if (resource == null) {
            return "minecraft:air";
        }
        return resource.toString();
    }

    public static String getId(ItemStack itemStack) {
        return ItemUtils.getId(itemStack.m_41720_()) + ItemUtils.getNbtString(itemStack);
    }

    public static Item getItem(String id) {
        String resourceId = id;
        if (id.contains("{") && id.endsWith("}")) {
            resourceId = resourceId.substring(0, id.indexOf("{"));
        }
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resourceId));
    }

    public static ItemStack getItemStack(String id) {
        ItemStack result = new ItemStack((ItemLike)Items.f_41852_);
        try {
            result = ItemUtils.getItemStack(id, false);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return result;
    }

    public static ItemStack getItemStack(String id, boolean throwException) throws CommandSyntaxException {
        Item item = ItemUtils.getItem(id);
        if (item == null) {
            throw new RuntimeException("Unknown item ID: " + id);
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (id.contains("{") && id.endsWith("}") && !id.endsWith("{}")) {
            try {
                String nbtString = id.substring(id.indexOf("{"));
                CompoundTag nbt = TagParser.m_129359_((String)nbtString);
                itemStack.m_41751_(nbt);
            }
            catch (Exception e) {
                if (throwException) {
                    throw e;
                }
                Const.LOGGER.error("Failed to parse NBT data", (Throwable)e);
            }
        }
        return itemStack;
    }

    public static String getNbtString(ItemStack itemStack) {
        String json = "";
        if (itemStack.m_41782_() && itemStack.m_41783_() != null) {
            json = itemStack.m_41783_().toString();
        }
        return json;
    }

    @NonNull
    public static ItemStack deserialize(JsonObject json) {
        ItemStack itemStack;
        block5: {
            try {
                String itemId = json.get("item").getAsString();
                int count = json.get("count").getAsInt();
                count = Math.max(count, 1);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                if (item == null) {
                    throw new JsonParseException("Unknown item ID: " + itemId);
                }
                itemStack = new ItemStack((ItemLike)item, count);
                if (!json.has("nbt")) break block5;
                try {
                    CompoundTag nbt = TagParser.m_129359_((String)json.get("nbt").getAsString());
                    itemStack.m_41751_(nbt);
                }
                catch (CommandSyntaxException e) {
                    throw new JsonParseException("Failed to parse NBT data", (Throwable)e);
                }
            }
            catch (Exception e) {
                Const.LOGGER.error("Failed to deserialize item reward", (Throwable)e);
                itemStack = new ItemStack((ItemLike)Items.f_41852_);
            }
        }
        return itemStack;
    }

    public static JsonObject serialize(ItemStack reward) {
        JsonObject json = new JsonObject();
        try {
            json.addProperty("item", ItemUtils.getId(reward.m_41720_()));
            json.addProperty("count", (Number)reward.m_41613_());
            if (reward.m_41782_() && reward.m_41783_() != null) {
                json.addProperty("nbt", ItemUtils.getNbtString(reward));
            }
        }
        catch (Exception e) {
            Const.LOGGER.error("Failed to serialize item reward", (Throwable)e);
            json.addProperty("item", ItemUtils.getId(Items.f_41852_));
            json.addProperty("count", (Number)0);
        }
        return json;
    }

    public String getDisplayName(JsonObject json) {
        return ItemUtils.deserialize(json).m_41611_().getString().replaceAll("\\[(.*)]", "$1");
    }

    public static String getDisplayName(ItemStack itemStack) {
        return itemStack.m_41611_().getString().replaceAll("\\[(.*)]", "$1");
    }

    public static String getDisplayName(Item item) {
        return new ItemStack((ItemLike)item).m_41611_().getString().replaceAll("\\[(.*)]", "$1");
    }

    public static ItemStack mapEquals(ItemStack stack, Map<ItemStack, Integer> map) {
        for (ItemStack itemStack : map.keySet()) {
            if (itemStack.m_41720_() != stack.m_41720_()) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            return container && stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return ItemUtils.withSize(stack, stack.m_41613_() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack, int amount, boolean container) {
        return stack.m_41619_() ? ItemStack.f_41583_ : ItemUtils.withSize(stack, stack.m_41613_() - amount, container);
    }

    public static ItemStack copyStack(@Nonnull ItemStack stack, int quantity) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(quantity);
        return stack;
    }

    public static boolean areStacksSameType(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return !stack1.m_41619_() && !stack2.m_41619_() && stack1.m_41720_() == stack2.m_41720_() && stack2.m_41773_() == stack1.m_41773_() && ItemStack.m_150942_((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        return ItemUtils.areStacksSameType(stack1, stack2) && stack1.m_41613_() + stack2.m_41613_() <= stack1.m_41741_();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41619_() ? stack2.m_41777_() : ItemUtils.grow(stack1, stack2.m_41613_());
    }

    public static boolean compareTags(ItemStack stack1, ItemStack stack2) {
        String key;
        if (!stack1.m_41782_()) {
            return true;
        }
        if (stack1.m_41782_() && !stack2.m_41782_()) {
            return false;
        }
        Set stack1Keys = NBTUtils.getTagCompound(stack1).m_128431_();
        Set stack2Keys = NBTUtils.getTagCompound(stack2).m_128431_();
        Iterator iterator = stack1Keys.iterator();
        do {
            if (!iterator.hasNext()) {
                return true;
            }
            key = (String)iterator.next();
            if (stack2Keys.contains(key)) continue;
            return false;
        } while (NbtUtils.m_129235_((Tag)NBTUtils.getTag(stack1, key), (Tag)NBTUtils.getTag(stack2, key), (boolean)true));
        return false;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(level, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.m_20334_(level.f_46441_.m_188583_() * 0.05, level.f_46441_.m_188583_() * 0.05 + (double)0.2f, level.f_46441_.m_188583_() * 0.05);
        level.m_7967_((Entity)item);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack, double velocity) {
        double xVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + xVelocity, (double)pos.m_123342_() + yVelocity, (double)pos.m_123343_() + zVelocity, stack);
        entityItem.m_32010_(10);
        world.m_7967_((Entity)entityItem);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(Level world, BlockPos pos, Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41613_() <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }

    public static void removeEnchant(ItemStack stack, Enchantment pEnchantment) {
        if (!stack.m_41784_().m_128425_("Enchantments", 9)) {
            stack.m_41784_().m_128365_("Enchantments", (Tag)new ListTag());
        }
        ListTag listtag = stack.m_41784_().m_128437_("Enchantments", 10);
        listtag.stream().filter(tag -> {
            CompoundTag compoundtag = (CompoundTag)tag;
            return Enchantment.m_44697_((int)compoundtag.m_128448_("id")) == pEnchantment;
        }).forEach(arg_0 -> listtag.remove(arg_0));
    }

    public static void clearEnchants(ItemStack stack) {
        if (stack.m_41784_().m_128425_("Enchantments", 9)) {
            stack.m_41784_().m_128473_("Enchantments");
        }
    }
}

