/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    public static int getEnvironmentBrightness(Player player) {
        int result = 0;
        if (player != null) {
            boolean isUnderground;
            Level world = player.m_9236_();
            BlockPos pos = player.m_20183_();
            int skyLight = world.m_45517_(LightLayer.SKY, pos);
            int blockLight = world.m_45517_(LightLayer.BLOCK, pos);
            boolean isDay = world.m_46461_();
            boolean isRaining = world.m_46471_();
            boolean isThundering = world.m_46470_();
            boolean bl = isUnderground = !world.m_45527_(pos);
            if (world.m_46472_() == Level.f_46428_) {
                if (!isUnderground) {
                    if (isDay) {
                        result = isThundering ? 6 : (isRaining ? 9 : 15);
                    } else {
                        int moonPhase = world.m_46941_();
                        result = WorldUtils.getMoonBrightness(moonPhase, isThundering, isRaining);
                    }
                } else {
                    result = Math.max(Math.min(blockLight, 12), 0);
                }
            } else {
                result = world.m_46472_() == Level.f_46429_ ? Math.min(7 + blockLight / 2, 10) : (world.m_46472_() == Level.f_46430_ ? Math.min(6 + blockLight / 2, 10) : Math.max(skyLight, blockLight));
            }
        }
        return result;
    }

    private static int getMoonBrightness(int moonPhase, boolean isThundering, boolean isRaining) {
        if (moonPhase == 0) {
            return isThundering ? 3 : (isRaining ? 5 : 9);
        }
        if (moonPhase == 4) {
            return isThundering ? 1 : 2;
        }
        int moonLight = 9 - moonPhase;
        return isThundering ? Math.max(moonLight - 3, 1) : (isRaining ? Math.max(moonLight - 2, 1) : moonLight);
    }

    public static List<BlockEntity> getBlockEntitiesWithinAABB(Level level, AABB bBox) {
        ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
        for (BlockPos pos : WorldUtils.getPositionsFromBox(bBox)) {
            BlockEntity blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos);
            if (blockEntity == null) continue;
            list.add(blockEntity);
        }
        return list;
    }

    public static Iterable<BlockPos> getPositionsFromBox(AABB box) {
        return WorldUtils.getPositionsFromBox(BlockPos.m_274561_((double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_), BlockPos.m_274561_((double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_));
    }

    public static Iterable<BlockPos> getPositionsFromBox(BlockPos corner1, BlockPos corner2) {
        return () -> BlockPos.m_121990_((BlockPos)corner1, (BlockPos)corner2).iterator();
    }

    @Nullable
    public static BlockEntity getBlockEntity(@Nullable BlockGetter level, @NotNull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(level, pos)) {
            return null;
        }
        return level.m_7702_(pos);
    }

    public static boolean isBlockLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).m_46739_(pos)) {
                return false;
            }
            return reader.m_46805_(pos);
        }
        return true;
    }
}

