/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigRecipeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CONFIG_PATH = "config/avaritia/recipes";

    public static Map<ResourceLocation, RecipeConfig> loadConfigRecipes() {
        HashMap<ResourceLocation, RecipeConfig> configs = new HashMap<ResourceLocation, RecipeConfig>();
        Path configDir = Paths.get(CONFIG_PATH, new String[0]);
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create config directory: {}", (Object)CONFIG_PATH, (Object)e);
                return configs;
            }
        }
        try {
            Files.walk(configDir, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (json != null) {
                        ResourceLocation recipeId = ConfigRecipeManager.getRecipeIdFromPath(path, configDir);
                        RecipeAction action = ConfigRecipeManager.parseAction(json);
                        String recipeType = GsonHelper.m_13851_((JsonObject)json, (String)"type", (String)"");
                        JsonObject recipeData = GsonHelper.m_13841_((JsonObject)json, (String)"recipe", (JsonObject)new JsonObject());
                        configs.put(recipeId, new RecipeConfig(action, recipeType, recipeData));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load recipe config: {}", path, (Object)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to walk config directory: {}", (Object)CONFIG_PATH, (Object)e);
        }
        return configs;
    }

    private static ResourceLocation getRecipeIdFromPath(Path path, Path root) {
        String relativePath = root.relativize(path).toString();
        String name = relativePath.substring(0, relativePath.length() - 5);
        return new ResourceLocation("avaritia", name.replace('\\', '/'));
    }

    private static RecipeAction parseAction(JsonObject json) {
        String actionStr = GsonHelper.m_13851_((JsonObject)json, (String)"action", (String)"ADD");
        try {
            return RecipeAction.valueOf(actionStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unknown recipe action: {}, defaulting to ADD", (Object)actionStr);
            return RecipeAction.ADD;
        }
    }

    public static enum RecipeAction {
        ADD,
        REMOVE,
        REPLACE;

    }

    public static class RecipeConfig {
        public RecipeAction action;
        public String recipeType;
        public JsonObject recipeData;

        public RecipeConfig(RecipeAction action, String recipeType, JsonObject recipeData) {
            this.action = action;
            this.recipeType = recipeType;
            this.recipeData = recipeData;
        }
    }
}

