/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.recipe;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import committee.nova.mods.avaritia.api.Lib;
import committee.nova.mods.avaritia.api.init.event.RegisterRecipesEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RecipeUtils {
    @Nullable
    private static WeakReference<RecipeManager> recipeManager;

    public static RecipeManager getRecipeManager() throws IllegalStateException {
        if (recipeManager == null || recipeManager.get() == null) {
            throw new IllegalStateException("Recipe Manager is not available");
        }
        return (RecipeManager)recipeManager.get();
    }

    @ApiStatus.Internal
    public static void setRecipeManager(RecipeManager manager) {
        recipeManager = new WeakReference<RecipeManager>(manager);
    }

    public static <I extends Container, T extends Recipe<I>> Map<ResourceLocation, T> byType(RecipeType<T> type) {
        return RecipeUtils.byType(RecipeUtils.getRecipeManager(), type);
    }

    public static <I extends Container, T extends Recipe<I>> Map<ResourceLocation, T> byType(RecipeManager manager, RecipeType<T> type) {
        return manager.m_44054_(type);
    }

    public static Collection<Recipe<?>> getAllRecipes() {
        return RecipeUtils.getRecipeManager().m_44051_();
    }

    public static void fireRecipeManagerLoadedEvent(RecipeManager manager, ICondition.IContext context, Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> map, Map<ResourceLocation, Recipe<?>> builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RegisterRecipesEvent(manager, context, recipes));
        }
        catch (Exception e) {
            Lib.LOGGER.error("An error occurred while firing RegisterRecipesEvent", (Throwable)e);
        }
        for (Recipe<?> recipe : recipes) {
            RecipeType recipeType = recipe.m_6671_();
            ConcurrentMap recipeMap = map.get(recipeType);
            if (!map.containsKey(recipeType)) {
                recipeMap = Maps.newConcurrentMap();
            }
            recipeMap.put(recipe.m_6423_(), recipe);
            map.put(recipe.m_6671_(), recipeMap);
            builder.put(recipe.m_6423_(), recipe);
        }
        Lib.LOGGER.info("Registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

