/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.util.ColorUtils;
import committee.nova.mods.avaritia.api.iface.IColored;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.model.entity.InfinityShieldModel;
import committee.nova.mods.avaritia.client.model.loader.CosmicArcModelLoader;
import committee.nova.mods.avaritia.client.model.loader.CosmicModelLoader;
import committee.nova.mods.avaritia.client.model.loader.EternalModelLoader;
import committee.nova.mods.avaritia.client.model.loader.HaloCosmicModelLoader;
import committee.nova.mods.avaritia.client.model.loader.HaloEternalModelLoader;
import committee.nova.mods.avaritia.client.model.loader.HaloModelLoader;
import committee.nova.mods.avaritia.client.model.loader.HellModelLoader;
import committee.nova.mods.avaritia.client.model.loader.UnstableModelLoader;
import committee.nova.mods.avaritia.client.particle.ChargeParticle;
import committee.nova.mods.avaritia.client.render.entity.InfinityArmorRender;
import committee.nova.mods.avaritia.client.render.tile.CompressedChestRender;
import committee.nova.mods.avaritia.client.render.tile.InfinityChestBlockRender;
import committee.nova.mods.avaritia.client.screen.AvaritiaConfigScreen;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModParticles;
import committee.nova.mods.avaritia.init.registry.ModSearches;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import java.util.Map;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AvaritiaModClient {
    public static final ModelLayerLocation COMPRESSED_CHEST = new ModelLayerLocation(Const.rl("compressed_chest"), "main");
    public static final ModelLayerLocation COMPRESSED_CHEST_LEFT = new ModelLayerLocation(Const.rl("compressed_chest_left"), "main");
    public static final ModelLayerLocation COMPRESSED_CHEST_RIGHT = new ModelLayerLocation(Const.rl("compressed_chest_right"), "main");
    public static final ModelLayerLocation INFINITY_CHEST = new ModelLayerLocation(Const.rl("infinity_chest"), "main");
    public static final ModelLayerLocation INFINITY_SHIELD = new ModelLayerLocation(Const.rl("infinity_shield"), "main");
    public static final ModelLayerLocation INFINITY_TRIDENT = new ModelLayerLocation(Const.rl("infinity_trident"), "main");

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        Const.LOGGER.debug("Registering key bindings");
        event.register(AvaritiaForgeClient.FILTER_KEY);
        event.register(AvaritiaForgeClient.RING_KEY);
    }

    @SubscribeEvent
    public static void clientSetUp(FMLClientSetupEvent event) {
        AvaritiaModClient.registerConfigScreen();
        ModEntities.onClientSetup();
        ModMenus.onClientSetup();
        ModTileEntities.onClientSetup();
        ModSearches.onClientSetup();
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.CHARGE.get(), ChargeParticle.Factory::new);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTexturesSwitchPost(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            int i;
            for (i = 0; i < AvaritiaShaders.COSMIC_SPRITES.length; ++i) {
                AvaritiaShaders.COSMIC_SPRITES[i] = event.getAtlas().m_118316_(Const.rl("misc/cosmic/cosmic_" + i));
                AvaritiaShaders.COSMIC_UVS[i * 4] = AvaritiaShaders.COSMIC_SPRITES[i].m_118409_();
                AvaritiaShaders.COSMIC_UVS[i * 4 + 1] = AvaritiaShaders.COSMIC_SPRITES[i].m_118411_();
                AvaritiaShaders.COSMIC_UVS[i * 4 + 2] = AvaritiaShaders.COSMIC_SPRITES[i].m_118410_();
                AvaritiaShaders.COSMIC_UVS[i * 4 + 3] = AvaritiaShaders.COSMIC_SPRITES[i].m_118412_();
            }
            for (i = 0; i < AvaritiaShaders.ETERNAL_SPRITES.length; ++i) {
                AvaritiaShaders.ETERNAL_SPRITES[i] = event.getAtlas().m_118316_(Const.rl("misc/eternal/eternal_" + i));
                AvaritiaShaders.ETERNAL_UVS[i * 4] = AvaritiaShaders.ETERNAL_SPRITES[i].m_118409_();
                AvaritiaShaders.ETERNAL_UVS[i * 4 + 1] = AvaritiaShaders.ETERNAL_SPRITES[i].m_118411_();
                AvaritiaShaders.ETERNAL_UVS[i * 4 + 2] = AvaritiaShaders.ETERNAL_SPRITES[i].m_118410_();
                AvaritiaShaders.ETERNAL_UVS[i * 4 + 3] = AvaritiaShaders.ETERNAL_SPRITES[i].m_118412_();
            }
            Res.ARMOR_MASK = event.getAtlas().m_118316_(Const.rl("mask/armor/infinity_armor_mask"));
            Res.ARMOR_MASK_INV = event.getAtlas().m_118316_(Const.rl("mask/armor/infinity_armor_mask_inv"));
            Res.ARMOR_WING_MASK = event.getAtlas().m_118316_(Const.rl("mask/armor/infinity_armor_mask_wings"));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRegisterShaders(RegisterShadersEvent event) {
        AvaritiaShaders.onRegisterShaders(event);
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(COMPRESSED_CHEST, CompressedChestRender::createSingleBodyLayer);
        event.registerLayerDefinition(COMPRESSED_CHEST_LEFT, CompressedChestRender::createDoubleBodyLeftLayer);
        event.registerLayerDefinition(COMPRESSED_CHEST_RIGHT, CompressedChestRender::createDoubleBodyRightLayer);
        event.registerLayerDefinition(INFINITY_CHEST, InfinityChestBlockRender::createLayer);
        event.registerLayerDefinition(INFINITY_SHIELD, InfinityShieldModel::createLayer);
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new IColored.ItemColors(), new ItemLike[]{(ItemLike)ModItems.singularity.get()});
        event.register((stack, index) -> AvaritiaModClient.getCurrentRainbowColor(), new ItemLike[]{(ItemLike)ModItems.eternal_singularity.get()});
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "endest_pearl_darkness", AvaritiaForgeClient.DARKNESS_OVERLAY);
    }

    @SubscribeEvent
    public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("cosmic", (IGeometryLoader)CosmicModelLoader.INSTANCE);
        event.register("cosmic_arc", (IGeometryLoader)CosmicArcModelLoader.INSTANCE);
        event.register("hell", (IGeometryLoader)HellModelLoader.INSTANCE);
        event.register("eternal", (IGeometryLoader)EternalModelLoader.INSTANCE);
        event.register("unstable", (IGeometryLoader)UnstableModelLoader.INSTANCE);
        event.register("halo", (IGeometryLoader)HaloModelLoader.INSTANCE);
        event.register("halo_cosmic", (IGeometryLoader)HaloCosmicModelLoader.INSTANCE);
        event.register("halo_eternal", (IGeometryLoader)HaloEternalModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void addPlayerLayer(EntityRenderersEvent.AddLayers event) {
        PlayerRenderer playerRenderer;
        LivingEntityRenderer entityRenderer = event.getRenderer(EntityType.f_20532_);
        if (entityRenderer instanceof PlayerRenderer && (playerRenderer = (PlayerRenderer)entityRenderer).m_7200_() instanceof HumanoidModel) {
            playerRenderer.m_115326_(new InfinityArmorRender(playerRenderer, event.getEntityModels(), false));
        }
        for (String model : event.getSkins()) {
            LivingEntityRenderer eventSkin = event.getSkin(model);
            eventSkin.m_115326_(new InfinityArmorRender(eventSkin, event.getEntityModels(), model.equals(DefaultPlayerSkin.ModelType.SLIM.name())));
        }
    }

    @SubscribeEvent
    public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
    }

    public static int getCurrentRainbowColor() {
        float hue = (float)(System.currentTimeMillis() % 18000L) / 18000.0f;
        return ColorUtils.HSBToRGB(hue, 1.0f, 1.0f);
    }

    private static void registerConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> new AvaritiaConfigScreen((Screen)parent)));
    }
}

