/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class InfinityArmorModel
extends HumanoidModel<LivingEntity> {
    public final ModelPart root = InfinityArmorModel.createLayer().m_171564_();
    public final ModelPart bodyRoot = InfinityArmorModel.createBodyLayer(new CubeDeformation(1.0f)).m_171564_();
    private boolean isSilm;

    public InfinityArmorModel(ModelPart root, boolean isSilm) {
        super(root);
        this.isSilm = isSilm;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        partDefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)1.2566371f, (float)0.0f));
        partDefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)-1.2566371f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubDeformation) {
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)cubDeformation, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubDeformation.m_171469_(-0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.m_171469_(-0.6f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.m_171469_(-0.6f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.m_171469_(-0.1f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.m_171469_(-0.1f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_);
    }

    public void setScale(ModelPart modelPart, float scale) {
        modelPart.f_233553_ = scale;
        modelPart.f_233554_ = scale;
        modelPart.f_233555_ = scale;
    }

    public void m_6973_(@NotNull LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelPart leftWing = this.root.m_171324_("left_wing");
        leftWing.f_104203_ = this.f_102810_.f_104203_;
        leftWing.f_104204_ = this.f_102810_.f_104204_ + 1.2566371f;
        leftWing.f_104205_ = this.f_102810_.f_104205_;
        ModelPart rightWing = this.root.m_171324_("right_wing");
        rightWing.f_104203_ = this.f_102810_.f_104203_;
        rightWing.f_104204_ = this.f_102810_.f_104204_ + -1.2566371f;
        rightWing.f_104205_ = this.f_102810_.f_104205_;
        if (livingEntity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)livingEntity;
            this.f_102808_.f_104201_ = 1.0f;
            this.f_102808_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123156_();
            this.f_102808_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123157_();
            this.f_102808_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123158_();
            this.f_102812_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123156_();
            this.f_102812_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123157_();
            this.f_102812_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123158_();
            this.f_102811_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123156_();
            this.f_102811_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123157_();
            this.f_102811_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123158_();
            this.f_102814_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123156_();
            this.f_102814_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123157_();
            this.f_102814_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123158_();
            this.f_102813_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123156_();
            this.f_102813_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123157_();
            this.f_102813_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123158_();
            this.f_102809_.m_104315_(this.f_102808_);
        }
        ModelPart head = this.bodyRoot.m_171324_("head");
        head.m_104315_(this.f_102808_);
        ModelPart hat = this.bodyRoot.m_171324_("hat");
        hat.m_104315_(this.f_102809_);
        ModelPart body = this.bodyRoot.m_171324_("body");
        body.m_104315_(this.f_102810_);
        if (livingEntity instanceof Zombie) {
            Zombie zombie = (Zombie)livingEntity;
            AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)zombie.m_5912_(), (float)this.f_102608_, (float)ageInTicks);
        }
        ModelPart leftArm = this.bodyRoot.m_171324_("left_arm");
        leftArm.m_104315_(this.f_102812_);
        if (!this.isSilm) {
            this.setScale(this.f_102812_, 1.01f);
        } else {
            this.f_102812_.f_104200_ -= 0.3f;
            this.f_102812_.f_233553_ = 0.8f;
            this.f_102812_.f_233554_ = 1.01f;
        }
        this.setScale(leftArm, 1.0f);
        ModelPart rightArm = this.bodyRoot.m_171324_("right_arm");
        rightArm.m_104315_(this.f_102811_);
        if (!this.isSilm) {
            this.setScale(this.f_102811_, 1.01f);
        } else {
            this.f_102811_.f_104200_ += 0.3f;
            this.f_102811_.f_233553_ = 0.8f;
            this.f_102811_.f_233554_ = 1.01f;
        }
        this.setScale(rightArm, 1.0f);
        ModelPart leftLeg = this.bodyRoot.m_171324_("left_leg");
        leftLeg.m_104315_(this.f_102814_);
        ModelPart rightLeg = this.bodyRoot.m_171324_("right_leg");
        rightLeg.m_104315_(this.f_102813_);
        ModelPart leftBoot = this.bodyRoot.m_171324_("left_boot");
        leftBoot.m_104315_(this.f_102814_);
        ModelPart rightBoot = this.bodyRoot.m_171324_("right_boot");
        rightBoot.m_104315_(this.f_102813_);
    }

    public void render(LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderType COSMIC_ARMOR_RENDER_TYPE = AvaritiaRenderTypes.COSMIC_ARMOR;
        Minecraft mc = Minecraft.m_91087_();
        Item headItem = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_();
        Item chestItem = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_();
        Item legsItem = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_();
        Item feetItem = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_();
        long time = mc.f_91073_.m_46467_();
        double pulse = Math.sin((double)time / 10.0) * 0.5 + 0.5;
        double pulse_mag_sqr = pulse * pulse * pulse * pulse * pulse * pulse;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaForgeClient.inventoryRender) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(livingEntity.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(livingEntity.m_146909_() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicArmorTime.m_5985_((float)(time % Integer.MAX_VALUE));
        AvaritiaShaders.cosmicArmorYaw.m_5985_(yaw);
        AvaritiaShaders.cosmicArmorPitch.m_5985_(pitch);
        AvaritiaShaders.cosmicArmorExternalScale.m_5985_(scale);
        AvaritiaShaders.cosmicArmorOpacity.m_5985_(1.25f);
        AvaritiaShaders.cosmicArmorUVs.m_5941_(AvaritiaShaders.COSMIC_UVS);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (chestItem == ModItems.infinity_chestplate.get() && player.m_150110_().f_35935_) {
                poseStack.m_85836_();
                ModelPart leftWing = this.root.m_171324_("left_wing");
                ModelPart rightWing = this.root.m_171324_("right_wing");
                leftWing.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
                rightWing.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
                leftWing.m_104306_(poseStack, Res.ARMOR_WING_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
                rightWing.m_104306_(poseStack, Res.ARMOR_WING_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
                leftWing.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.WING_GLOW_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
                rightWing.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.WING_GLOW_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
                poseStack.m_85849_();
            }
        }
        if (headItem == ModItems.infinity_helmet.get()) {
            poseStack.m_85836_();
            ModelPart head = this.bodyRoot.m_171324_("head");
            head.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            ModelPart hat = this.bodyRoot.m_171324_("hat");
            hat.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
        if (chestItem == ModItems.infinity_chestplate.get()) {
            poseStack.m_85836_();
            ModelPart body = this.bodyRoot.m_171324_("body");
            body.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            body.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            ModelPart leftArm = this.bodyRoot.m_171324_("left_arm");
            leftArm.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            leftArm.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            ModelPart rightArm = this.bodyRoot.m_171324_("right_arm");
            rightArm.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            rightArm.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            poseStack.m_85849_();
        }
        if (legsItem == ModItems.infinity_pants.get()) {
            poseStack.m_85836_();
            ModelPart leftLeg = this.bodyRoot.m_171324_("left_leg");
            leftLeg.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            leftLeg.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            ModelPart rightLeg = this.bodyRoot.m_171324_("right_leg");
            rightLeg.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            rightLeg.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            poseStack.m_85849_();
        }
        if (feetItem == ModItems.infinity_boots.get()) {
            poseStack.m_85836_();
            ModelPart leftBoot = this.bodyRoot.m_171324_("left_boot");
            leftBoot.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            ModelPart rightBoot = this.bodyRoot.m_171324_("right_boot");
            rightBoot.m_104306_(poseStack, Res.ARMOR_MASK.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
        if (headItem == ModItems.infinity_helmet.get() && chestItem == ModItems.infinity_chestplate.get() && legsItem == ModItems.infinity_pants.get() && feetItem == ModItems.infinity_boots.get()) {
            poseStack.m_85836_();
            ModelPart hat = this.bodyRoot.m_171324_("hat");
            float hue = (float)(System.currentTimeMillis() - AvaritiaForgeClient.lastTime) / 2000.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            hat.m_104306_(poseStack, multiBufferSource.m_6299_(AvaritiaRenderTypes.Glow(Res.EYE_TEX)), packedLight, packedOverlay, r, g, b, alpha);
            super.m_7695_(poseStack, Res.ARMOR_MASK_INV.m_118381_(multiBufferSource.m_6299_(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    public static Material material(ResourceLocation t) {
        return new Material(InventoryMenu.f_39692_, t);
    }
}

