/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.util.TransformUtils;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.model.entity.InfinityTridentModel;
import committee.nova.mods.avaritia.client.render.util.ArcRender;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CosmicArcBakeModel
extends WrappedItemModel {
    private final List<ResourceLocation> maskSprite;

    public CosmicArcBakeModel(BakedModel wrapped, List<ResourceLocation> maskSprite) {
        super(wrapped);
        this.maskSprite = maskSprite;
        this.cosmic = true;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int packedLight, int packedOverlay, ItemModelShaper itemModelShaper, TextureManager textureManager) {
        if (stack.m_150930_((Item)ModItems.infinity_trident.get())) {
            this.parentState = TransformUtils.DEFAULT_TRIDENT;
            if (transformType == ItemDisplayContext.GUI || transformType == ItemDisplayContext.GROUND || transformType == ItemDisplayContext.FIXED) {
                this.cosmic = true;
                this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
            } else {
                this.cosmic = false;
                InfinityTridentModel tridentModel = new InfinityTridentModel();
                pStack.m_85836_();
                pStack.m_85841_(1.0f, -1.0f, -1.0f);
                VertexConsumer vertexconsumer1 = ItemRenderer.m_115222_((MultiBufferSource)source, (RenderType)tridentModel.m_103119_(Res.TRIDENT_TEX), (boolean)false, (boolean)stack.m_41790_());
                tridentModel.m_7695_(pStack, vertexconsumer1, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                pStack.m_85849_();
            }
        } else {
            this.parentState = TransformUtils.DEFAULT_ITEM;
            this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
        }
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.m_109911_();
        }
        if (transformType != ItemDisplayContext.GUI && transformType != ItemDisplayContext.GROUND) {
            pStack.m_85836_();
            float startX = 0.0f;
            float startY = -0.5f;
            float startZ = 0.0f;
            float endX = 0.0f;
            float endY = 0.0f;
            float endZ = 0.0f;
            long seed = System.currentTimeMillis();
            float thickness = 0.02f;
            int segments = 8;
            pStack.m_252781_(Axis.f_252436_.m_252977_((float)(System.currentTimeMillis() / 10L % 360L)));
            ArcRender.renderArc(pStack, source, seed, startX, startY, startZ, endX, endY, endZ, thickness, segments);
            pStack.m_85849_();
        }
        Minecraft mc = Minecraft.m_91087_();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaForgeClient.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
            yaw = (float)((double)(mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicTime.m_5985_((float)(mc.f_91073_.m_46467_() % Integer.MAX_VALUE));
        AvaritiaShaders.cosmicYaw.m_5985_(yaw);
        AvaritiaShaders.cosmicPitch.m_5985_(pitch);
        AvaritiaShaders.cosmicExternalScale.m_5985_(scale);
        AvaritiaShaders.cosmicOpacity.m_5985_(1.0f);
        AvaritiaShaders.cosmicUVs.m_5941_(AvaritiaShaders.COSMIC_UVS);
        VertexConsumer cons = source.m_6299_(AvaritiaRenderTypes.COSMIC);
        ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation res : this.maskSprite) {
            atlasSprite.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(res));
        }
        mc.m_91291_().m_115162_(pStack, cons, CosmicArcBakeModel.bakeItem(atlasSprite), stack, packedLight, packedOverlay);
    }
}

