/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.common.entity.AcceleratorDisplayEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AcceleratorDisplayRender
extends EntityRenderer<AcceleratorDisplayEntity> {
    private final Font font;
    private static final float SCALE = 0.02f;

    public AcceleratorDisplayRender(EntityRendererProvider.Context context) {
        super(context);
        this.font = context.m_174028_();
    }

    public void render(AcceleratorDisplayEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        String text = "x" + entity.getSpeedMultiplier();
        float textWidth = (float)this.font.m_92895_(text) * 0.02f / 2.0f;
        Direction face = entity.getFace();
        this.drawTextOnFace(poseStack, buffer, text, face, textWidth, packedLight);
    }

    private void drawTextOnFace(PoseStack poseStack, MultiBufferSource buffer, String text, Direction face, float textWidth, int light) {
        poseStack.m_85836_();
        switch (face) {
            case UP: {
                poseStack.m_85837_(0.0, 0.51, 0.0);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_85837_(0.0, -0.51, 0.0);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.m_85837_(0.0, 0.0, -0.51);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.0, 0.0, 0.51);
                break;
            }
            case WEST: {
                poseStack.m_85837_(-0.51, 0.0, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case EAST: {
                poseStack.m_85837_(0.51, 0.0, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
        }
        poseStack.m_85841_(0.02f, -0.02f, 0.02f);
        poseStack.m_252880_(-textWidth, 0.0f, 0.0f);
        this.font.m_271703_(text, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, light);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(AcceleratorDisplayEntity entity) {
        return null;
    }
}

