/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.client.AvaritiaModClient;
import committee.nova.mods.avaritia.common.tile.CompressedChestTile;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CompressedChestRender
implements BlockEntityRenderer<CompressedChestTile> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;

    public CompressedChestRender(BlockEntityRendererProvider.Context pContext) {
        ModelPart modelpart = pContext.m_173582_(AvaritiaModClient.COMPRESSED_CHEST);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
        ModelPart modelpart1 = pContext.m_173582_(AvaritiaModClient.COMPRESSED_CHEST_LEFT);
        this.doubleLeftBottom = modelpart1.m_171324_("bottom");
        this.doubleLeftLid = modelpart1.m_171324_("lid");
        this.doubleLeftLock = modelpart1.m_171324_("lock");
        ModelPart modelpart2 = pContext.m_173582_(AvaritiaModClient.COMPRESSED_CHEST_RIGHT);
        this.doubleRightBottom = modelpart2.m_171324_("bottom");
        this.doubleRightLid = modelpart2.m_171324_("lid");
        this.doubleRightLock = modelpart2.m_171324_("lock");
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(CompressedChestTile pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? pBlockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            pPoseStack.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            pPoseStack.m_252880_(0.5f, 0.5f, 0.5f);
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            pPoseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.m_5641_(blockstate, level, pBlockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)pBlockEntity))).get(pPartialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pPackedLight);
            VertexConsumer vertexconsumer = new Material(Sheets.f_110740_, Const.rl("block/chest/compressed_chest")).m_119194_(pBuffer, RenderType::m_110452_);
            if (flag1) {
                vertexconsumer = this.getMaterial(pBlockEntity, chesttype).m_119194_(pBuffer, RenderType::m_110452_);
                if (chesttype == ChestType.LEFT) {
                    this.render(pPoseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, pPackedOverlay);
                } else {
                    this.render(pPoseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, pPackedOverlay);
                }
            } else {
                this.render(pPoseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, pPackedOverlay);
            }
            pPoseStack.m_85849_();
        }
    }

    private void render(PoseStack pPoseStack, VertexConsumer pConsumer, ModelPart pLidPart, ModelPart pLockPart, ModelPart pBottomPart, float pLidAngle, int pPackedLight, int pPackedOverlay) {
        pLockPart.f_104203_ = pLidPart.f_104203_ = -(pLidAngle * 1.5707964f);
        pLidPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLockPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pBottomPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    protected Material getMaterial(CompressedChestTile blockEntity, ChestType chestType) {
        return Sheets.m_110767_((BlockEntity)blockEntity, (ChestType)chestType, (boolean)false);
    }
}

