/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.crafting.ISpecialRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CompressorRecipe
implements ISpecialRecipe,
ICompressorRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int inputCount;
    private final int timeRequire;

    public CompressorRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output, int inputCount, int timeRequire) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
        this.output = output;
        this.inputCount = inputCount;
        this.timeRequire = timeRequire;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.output;
    }

    @NotNull
    public ItemStack getResultItem() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @Override
    public int getTimeCost() {
        return this.timeRequire;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.COMPRESSOR_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get();
    }

    @Override
    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    @Override
    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        ItemStack input = inventory.getStackInSlot(0);
        return ((Ingredient)this.inputs.get(0)).test(input);
    }

    @Override
    public boolean m_5818_(@NotNull Container inv, @NotNull Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public static class Serializer
    implements RecipeSerializer<CompressorRecipe> {
        @NotNull
        public CompressorRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int inputCount = GsonHelper.m_13824_((JsonObject)json, (String)"inputCount", (int)1000);
            int timeCost = GsonHelper.m_13927_((JsonObject)json, (String)"timeCost");
            return new CompressorRecipe(recipeId, input, output, inputCount, timeCost);
        }

        public CompressorRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int inputCount = buffer.readInt();
            int timeCost = buffer.readInt();
            return new CompressorRecipe(recipeId, input, output, inputCount, timeCost);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, CompressorRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.writeInt(recipe.inputCount);
            buffer.writeInt(recipe.timeRequire);
        }
    }
}

