/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FullMatterClusterRecipe
extends ShapelessTableCraftingRecipe {
    private final String group;
    private final int count;

    public FullMatterClusterRecipe(ResourceLocation recipeId, String group, NonNullList<Ingredient> inputs, int count) {
        super(recipeId, inputs, new ItemStack((ItemLike)ModItems.full_matter_cluster.get()), 1);
        this.group = group;
        this.count = count;
    }

    @Override
    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        if (!super.m_5818_(container, level)) {
            return false;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof MatterClusterItem)) continue;
            MatterClusterItem clusterItem = (MatterClusterItem)item;
            if (MatterClusterItem.getClusterSize(stack) < 4096) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FULL_MATTER_CLUSTER_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<FullMatterClusterRecipe> {
        @NotNull
        public FullMatterClusterRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"default");
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new FullMatterClusterRecipe(recipeId, group, (NonNullList<Ingredient>)inputs, count);
        }

        public FullMatterClusterRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int count = buffer.readInt();
            return new FullMatterClusterRecipe(recipeId, group, (NonNullList<Ingredient>)inputs, count);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull FullMatterClusterRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeInt(recipe.count);
        }
    }
}

