/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.handler.SingularityRegistryHandler;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.util.SingularityUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class InfinityCatalystCraftRecipe
extends ShapelessTableCraftingRecipe {
    private static final Object2BooleanOpenHashMap<InfinityCatalystCraftRecipe> INGREDIENTS_LOADED = new Object2BooleanOpenHashMap();
    private final String group;
    private final int count;
    private final NonNullList<Ingredient> originalInputs;

    public InfinityCatalystCraftRecipe(ResourceLocation recipeId, String pGroup, NonNullList<Ingredient> inputs, int count) {
        super(recipeId, (NonNullList<Ingredient>)NonNullList.m_122779_(), new ItemStack((ItemLike)ModItems.infinity_catalyst.get()), 4);
        this.group = pGroup;
        this.count = count;
        this.originalInputs = inputs;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        if (!INGREDIENTS_LOADED.getOrDefault((Object)this, false)) {
            super.m_7527_().clear();
            if ("default".equals(this.group)) {
                super.m_7527_().addAll(this.originalInputs);
                SingularityRegistryHandler.getInstance().getSingularities().stream().filter(singularity -> singularity.getIngredient() != Ingredient.f_43901_).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> super.m_7527_().add(arg_0));
            } else {
                super.m_7527_().addAll(this.originalInputs);
            }
            INGREDIENTS_LOADED.put((Object)this, true);
        }
        return super.m_7527_();
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.INFINITY_CATALYST_CRAFT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<InfinityCatalystCraftRecipe> {
        @NotNull
        public InfinityCatalystCraftRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group1 = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"default");
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new InfinityCatalystCraftRecipe(recipeId, group1, (NonNullList<Ingredient>)inputs, count);
        }

        public InfinityCatalystCraftRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int count = buffer.readInt();
            return new InfinityCatalystCraftRecipe(recipeId, group, (NonNullList<Ingredient>)inputs, count);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull InfinityCatalystCraftRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.originalInputs.size());
            for (Ingredient ingredient : recipe.originalInputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeInt(recipe.count);
        }
    }
}

