/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityTridentItem;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class InfinityThrownTrident
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.m_135353_(InfinityThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOCKWAVE = SynchedEntityData.m_135353_(InfinityThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(InfinityThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ItemStack tridentItem = new ItemStack((ItemLike)ModItems.infinity_trident.get());
    private boolean dealtDamage;
    private boolean noReturn;
    private int loyaltyLevel = 3;
    public int returningTicks;

    public InfinityThrownTrident(EntityType<? extends InfinityThrownTrident> type, Level worldIn) {
        super(type, worldIn);
    }

    public InfinityThrownTrident(Level world, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)ModEntities.infinity_thrown_trident.get(), thrower, world);
        this.setStackAndLoyalty(thrownStackIn.m_41777_());
        this.f_19804_.m_135381_(SHOCKWAVE, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentShockwave(this.tridentItem));
        this.f_19804_.m_135381_(CHANNELING, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentChanneling(this.tridentItem));
    }

    private void setStackAndLoyalty(@NotNull ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof InfinityTridentItem) {
            InfinityTridentItem trident = (InfinityTridentItem)item;
            this.tridentItem = stack;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOCKWAVE, (Object)false);
        this.f_19804_.m_135372_(CHANNELING, (Object)false);
        this.f_19804_.m_135372_(RADIUS, (Object)1);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
            this.noReturn = !this.isAcceptableReturnOwner();
        }
        Entity entity = this.m_19749_();
        if (!this.noReturn && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (this.isAcceptableReturnOwner() && this.loyaltyLevel > 0) {
                this.m_36790_(true);
                Vec3 returnVector = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + returnVector.f_82480_ * 0.015 * (double)this.loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(returnVector.m_82541_().m_82490_(0.05 * (double)this.loyaltyLevel)));
                if (this.returningTicks == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            } else {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_142036_();
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.tridentItem.m_41777_();
    }

    protected void m_5790_(EntityHitResult result) {
        List mobs;
        Entity hitEntity = result.m_82443_();
        float damage = Float.MAX_VALUE;
        Entity thrower = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(thrower == null ? this : thrower));
        this.dealtDamage = true;
        if (hitEntity.m_6469_(damagesource, damage) && hitEntity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)hitEntity;
            if (thrower instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingHit, (Entity)thrower);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)thrower), (Entity)livingHit);
            }
            this.m_7761_(livingHit);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float volume = 1.0f;
        SoundEvent sound = SoundEvents.f_12514_;
        AABB area = new AABB(hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_(), hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_()).m_82400_((double)((Integer)this.f_19804_.m_135370_(RADIUS)).intValue());
        List list = mobs = (Boolean)this.f_19804_.m_135370_(SHOCKWAVE) != false ? this.m_20193_().m_45976_(Mob.class, area) : Collections.emptyList();
        if (thrower instanceof Player && ((Boolean)this.f_19804_.m_135370_(SHOCKWAVE)).booleanValue()) {
            mobs.forEach(mobEntity -> mobEntity.m_6469_(mobEntity.m_269291_().m_269075_((Player)thrower), damage));
            this.m_20193_().m_45976_(ItemEntity.class, area.m_82400_(1.0)).forEach(itemEntity -> {
                itemEntity.m_32061_();
                itemEntity.m_6021_((double)thrower.m_20183_().m_123341_(), (double)(thrower.m_20183_().m_123342_() + 1), (double)thrower.m_20183_().m_123343_());
            });
            this.m_20193_().m_45976_(ExperienceOrb.class, area.m_82400_(1.0)).forEach(entityXPOrb -> entityXPOrb.m_6021_((double)thrower.m_20183_().m_123341_(), (double)thrower.m_20183_().m_123342_(), (double)thrower.m_20183_().m_123343_()));
        }
        if (this.m_9236_() instanceof ServerLevel && ((Boolean)this.f_19804_.m_135370_(CHANNELING)).booleanValue()) {
            BlockPos blockpos = hitEntity.m_20183_();
            if (this.m_9236_().m_45527_(blockpos)) {
                ToolUtils.trySummonLightning(this.m_9236_(), 1, blockpos, thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null);
                sound = SoundEvents.f_12521_;
                volume = 5.0f;
                mobs.forEach(mobEntity -> {
                    if (this.m_9236_().m_45527_(mobEntity.m_20183_())) {
                        ToolUtils.trySummonLightning(this.m_9236_(), 1, mobEntity.m_20183_(), thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null);
                    }
                });
            }
        }
        this.m_5496_(sound, volume, 1.0f);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Trident", 10)) {
            this.setStackAndLoyalty(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Trident")));
        }
        this.dealtDamage = compound.m_128471_("DealtDamage");
        this.noReturn = compound.m_128471_("NoReturn");
        this.f_19804_.m_135381_(SHOCKWAVE, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentShockwave(this.tridentItem));
        this.f_19804_.m_135381_(CHANNELING, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentChanneling(this.tridentItem));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Trident", (Tag)this.tridentItem.serializeNBT());
        compound.m_128379_("DealtDamage", this.dealtDamage);
        compound.m_128379_("NoReturn", this.noReturn);
    }

    protected void m_6901_() {
    }

    protected float m_6882_() {
        return 1.49f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.tridentItem);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.setStackAndLoyalty(buffer.m_130267_());
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.tridentItem.m_41777_();
    }

    @Generated
    public void setLoyaltyLevel(int loyaltyLevel) {
        this.loyaltyLevel = loyaltyLevel;
    }
}

