/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.iface.IInfinityClockSwitchable;
import committee.nova.mods.avaritia.common.entity.AcceleratorDisplayEntity;
import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.common.menu.InfinityClockMenu;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class InfinityClockItem
extends ResourceItem
implements IInfinityClockSwitchable {
    public static final Map<ResourceKey<Level>, Map<BlockPos, Integer>> acceleratedBlocks = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();
    private static final Map<ResourceKey<Level>, Map<BlockPos, AcceleratorDisplayEntity>> displayEntities = new HashMap<ResourceKey<Level>, Map<BlockPos, AcceleratorDisplayEntity>>();

    public InfinityClockItem() {
        super(ModRarities.COSMIC, true, new Item.Properties().m_41487_(1));
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        boolean upMode = this.isActive(stack, "infinity_clock_up");
        if (player.m_6144_()) {
            this.switchClockMode(level, player, hand, "infinity_clock_up");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (upMode) {
            int current = stack.m_41784_().m_128451_("SpeedMultiplier");
            int next = switch (current) {
                case 1 -> 4;
                case 4 -> 16;
                case 16 -> 64;
                case 64 -> 256;
                case 256 -> 512;
                default -> 1;
            };
            stack.m_41784_().m_128405_("SpeedMultiplier", next);
            player.m_5661_((Component)Component.m_237113_((String)(next + "x")), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, buf) -> new InfinityClockMenu(id, inv), (Component)Component.m_237115_((String)"item.avaritia.infinity_clock")));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction face = ctx.m_43719_();
        if (!this.isActive(stack, "infinity_clock_up")) {
            this.removeAcceleration(level, pos);
            return InteractionResult.CONSUME;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41784_();
        int multiplier = tag.m_128451_("SpeedMultiplier");
        if (multiplier == 0) {
            multiplier = 1;
            tag.m_128405_("SpeedMultiplier", multiplier);
        }
        if (multiplier == 1) {
            this.removeAcceleration(level, pos);
            return InteractionResult.CONSUME;
        }
        acceleratedBlocks.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new HashMap()).put(pos.m_7949_(), multiplier);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.removeDisplayEntity(level, pos);
            AcceleratorDisplayEntity entity = new AcceleratorDisplayEntity(level, pos, multiplier, face);
            serverLevel.m_7967_((Entity)entity);
            displayEntities.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new HashMap()).put(pos.m_7949_(), entity);
        }
        return InteractionResult.CONSUME;
    }

    private void removeAcceleration(Level level, BlockPos pos) {
        ResourceKey dimension = level.m_46472_();
        if (acceleratedBlocks.containsKey(dimension)) {
            acceleratedBlocks.get(dimension).remove(pos);
            if (acceleratedBlocks.get(dimension).isEmpty()) {
                acceleratedBlocks.remove(dimension);
            }
        }
        this.removeDisplayEntity(level, pos);
    }

    private void removeDisplayEntity(Level level, BlockPos pos) {
        ResourceKey dimension = level.m_46472_();
        if (displayEntities.containsKey(dimension)) {
            AcceleratorDisplayEntity entity = displayEntities.get(dimension).get(pos);
            if (entity != null && !entity.m_213877_()) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            displayEntities.get(dimension).remove(pos);
            if (displayEntities.get(dimension).isEmpty()) {
                displayEntities.remove(dimension);
            }
        }
    }

    public static AcceleratedBlocksSavedData getSavedData(ServerLevel level) {
        return (AcceleratedBlocksSavedData)level.m_8895_().m_164861_(AcceleratedBlocksSavedData::new, AcceleratedBlocksSavedData::new, "avaritia_accelerated_blocks");
    }

    public static void loadAcceleratedBlocksFromSavedData(ServerLevel level) {
        AcceleratedBlocksSavedData savedData = InfinityClockItem.getSavedData(level);
        acceleratedBlocks.clear();
        acceleratedBlocks.putAll(savedData.getAcceleratedBlocks());
        for (Map.Entry<ResourceKey<Level>, Map<BlockPos, Integer>> dimensionEntry : acceleratedBlocks.entrySet()) {
            ResourceKey<Level> dimension = dimensionEntry.getKey();
            Map<BlockPos, Integer> blocks = dimensionEntry.getValue();
            for (Map.Entry<BlockPos, Integer> blockEntry : blocks.entrySet()) {
                BlockPos pos = blockEntry.getKey();
                int multiplier = blockEntry.getValue();
                if (!level.m_46749_(pos) || multiplier <= 1) continue;
                AcceleratorDisplayEntity entity = new AcceleratorDisplayEntity((Level)level, pos, multiplier, Direction.NORTH);
                level.m_7967_((Entity)entity);
                displayEntities.computeIfAbsent(dimension, k -> new HashMap()).put(pos.m_7949_(), entity);
            }
        }
    }

    public static void saveAcceleratedBlocksToSavedData(ServerLevel level) {
        AcceleratedBlocksSavedData savedData = InfinityClockItem.getSavedData(level);
        savedData.setAcceleratedBlocks(acceleratedBlocks);
    }

    public static class AcceleratedBlocksSavedData
    extends SavedData {
        public static final String NAME = "avaritia_accelerated_blocks";
        private final Map<ResourceKey<Level>, Map<BlockPos, Integer>> acceleratedBlocks = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();

        public AcceleratedBlocksSavedData() {
        }

        public AcceleratedBlocksSavedData(CompoundTag nbt) {
            ListTag dimensionsList = nbt.m_128437_("Dimensions", 10);
            for (int i = 0; i < dimensionsList.size(); ++i) {
                CompoundTag dimensionTag = dimensionsList.m_128728_(i);
                ResourceLocation dimensionLocation = new ResourceLocation(dimensionTag.m_128461_("Dimension"));
                ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionLocation);
                HashMap<BlockPos, Integer> blocksMap = new HashMap<BlockPos, Integer>();
                ListTag blocksList = dimensionTag.m_128437_("Blocks", 10);
                for (int j = 0; j < blocksList.size(); ++j) {
                    CompoundTag blockTag = blocksList.m_128728_(j);
                    BlockPos pos = BlockPos.m_122022_((long)blockTag.m_128454_("Pos"));
                    int multiplier = blockTag.m_128451_("Multiplier");
                    blocksMap.put(pos, multiplier);
                }
                this.acceleratedBlocks.put((ResourceKey<Level>)dimensionKey, blocksMap);
            }
        }

        public CompoundTag m_7176_(CompoundTag compound) {
            ListTag dimensionsList = new ListTag();
            for (Map.Entry<ResourceKey<Level>, Map<BlockPos, Integer>> dimensionEntry : this.acceleratedBlocks.entrySet()) {
                CompoundTag dimensionTag = new CompoundTag();
                dimensionTag.m_128359_("Dimension", dimensionEntry.getKey().m_135782_().toString());
                ListTag blocksList = new ListTag();
                for (Map.Entry<BlockPos, Integer> blockEntry : dimensionEntry.getValue().entrySet()) {
                    CompoundTag blockTag = new CompoundTag();
                    blockTag.m_128356_("Pos", blockEntry.getKey().m_121878_());
                    blockTag.m_128405_("Multiplier", blockEntry.getValue().intValue());
                    blocksList.add((Object)blockTag);
                }
                dimensionTag.m_128365_("Blocks", (Tag)blocksList);
                dimensionsList.add((Object)dimensionTag);
            }
            compound.m_128365_("Dimensions", (Tag)dimensionsList);
            return compound;
        }

        public Map<ResourceKey<Level>, Map<BlockPos, Integer>> getAcceleratedBlocks() {
            return this.acceleratedBlocks;
        }

        public void setAcceleratedBlocks(Map<ResourceKey<Level>, Map<BlockPos, Integer>> blocks) {
            this.acceleratedBlocks.clear();
            this.acceleratedBlocks.putAll(blocks);
            this.m_77762_();
        }
    }

    @Mod.EventBusSubscriber
    public static class TickHandler {
        @SubscribeEvent
        public static void onServerTick(TickEvent.LevelTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Level level = event.level;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            Map<BlockPos, Integer> map = acceleratedBlocks.get(level2.m_46472_());
            if (map == null || map.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<BlockPos, Integer>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                AcceleratorDisplayEntity entity;
                Map.Entry<BlockPos, Integer> entry = it.next();
                BlockPos pos = entry.getKey();
                int times = entry.getValue();
                if (times == 1) {
                    it.remove();
                    TickHandler.removeDisplayEntity((Level)level2, pos);
                    continue;
                }
                if (!level2.m_46749_(pos)) continue;
                BlockState state = level2.m_8055_(pos);
                Block block = state.m_60734_();
                if (block instanceof BonemealableBlock) {
                    BonemealableBlock growable = (BonemealableBlock)block;
                    RandomSource random = level2.m_213780_();
                    for (int i = 0; i < times && growable.m_7370_((LevelReader)level2, pos, state, false); ++i) {
                        if (!growable.m_214167_((Level)level2, random, pos, state)) continue;
                        try {
                            growable.m_214148_(level2, random, pos, state);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                        state = level2.m_8055_(pos);
                    }
                    if (level2.m_46467_() % 5L != 0L) continue;
                    TickHandler.addAccelerationParticles(level2, pos, times);
                    continue;
                }
                BlockEntity be = level2.m_7702_(pos);
                if (be != null) {
                    ToolUtils.accelerateBlockEntity(level2, pos, be, times);
                    if (level2.m_46467_() % 5L == 0L) {
                        TickHandler.addAccelerationParticles(level2, pos, times);
                    }
                } else {
                    it.remove();
                    TickHandler.removeDisplayEntity((Level)level2, pos);
                }
                if ((entity = (AcceleratorDisplayEntity)((Object)((Map)displayEntities.getOrDefault(level2.m_46472_(), new HashMap())).get(pos))) != null) {
                    if (entity.getSpeedMultiplier() == times) continue;
                    entity.setSpeedMultiplier(times);
                    continue;
                }
                if (times <= 1) continue;
                AcceleratorDisplayEntity newEntity = new AcceleratorDisplayEntity((Level)level2, pos, times, Direction.NORTH);
                level2.m_7967_((Entity)newEntity);
                displayEntities.computeIfAbsent((ResourceKey<Level>)level2.m_46472_(), k -> new HashMap()).put(pos.m_7949_(), newEntity);
            }
        }

        private static void addAccelerationParticles(ServerLevel level, BlockPos pos, int times) {
            long gameTime = level.m_46467_();
            for (int i = 0; i < 10; ++i) {
                double hAngle = ((double)gameTime * 0.5 + (double)(i * 40)) % 360.0;
                double hRadius = 0.6;
                double hX = (double)pos.m_123341_() + 0.5 + Math.cos(Math.toRadians(hAngle)) * hRadius;
                double hZ = (double)pos.m_123343_() + 0.5 + Math.sin(Math.toRadians(hAngle)) * hRadius;
                double hY = (double)pos.m_123342_() + 0.5 + (double)(i % 3 - 1) * 0.2;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, hX, hY, hZ, 1, 0.0, 0.0, 0.0, 0.0);
                double vAngle = ((double)gameTime * 0.7 + (double)(i * 60)) % 360.0;
                double vRadius = 0.6;
                double vX = (double)pos.m_123341_() + 0.5 + Math.cos(Math.toRadians(vAngle)) * vRadius;
                double vY = (double)pos.m_123342_() + 0.5 + Math.sin(Math.toRadians(vAngle)) * vRadius;
                double vZ = (double)pos.m_123343_() + 0.5 + ((double)(i % 2) - 0.5) * 0.2;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, vX, vY, vZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private static void removeDisplayEntity(Level level, BlockPos pos) {
            ResourceKey dimension = level.m_46472_();
            if (displayEntities.containsKey(dimension)) {
                AcceleratorDisplayEntity entity = displayEntities.get(dimension).get(pos);
                if (entity != null && !entity.m_213877_()) {
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                displayEntities.get(dimension).remove(pos);
                if (displayEntities.get(dimension).isEmpty()) {
                    displayEntities.remove(dimension);
                }
            }
        }
    }
}

