/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IToolTransform;
import committee.nova.mods.avaritia.common.entity.RainProEntity;
import committee.nova.mods.avaritia.common.entity.StormProEntity;
import committee.nova.mods.avaritia.common.entity.SunProEntity;
import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class InfinityUmbrellaItem
extends ResourceItem
implements ISwitchable,
IToolTransform {
    public static final List<String> MODES = Arrays.asList("infinity_umbrella_normal", "infinity_umbrella_sun", "infinity_umbrella_rain", "infinity_umbrella_storm");
    private static final int MODE_NORMAL = 0;
    private static final int MODE_SUN = 1;
    private static final int MODE_RAIN = 2;
    private static final int MODE_STORM = 3;
    private static final int MIN_DURATION = 12000;
    private static final int MAX_DURATION = 24000;

    public InfinityUmbrellaItem() {
        super(ModRarities.COSMIC, true, new Item.Properties().m_41487_(1));
    }

    private int getRandomDuration(Level level) {
        return 12000 + level.f_46441_.m_188503_(12001);
    }

    private void onUse(Level level, Player player, ItemStack stack, @NotNull InteractionHand hand) {
        if (!level.f_46443_) {
            float pitch = player.m_146909_();
            int currentMode = ISwitchable.getCurrentMode(stack, MODES);
            int duration = this.getRandomDuration(level);
            switch (currentMode) {
                case 0: {
                    break;
                }
                case 1: {
                    SunProEntity sunProEntity = (SunProEntity)((EntityType)ModEntities.SUN_PRO.get()).m_20615_(level);
                    if (pitch <= -85.0f) {
                        if (!level.m_6106_().m_6533_() && level.m_6106_().m_6534_()) break;
                        level.m_6106_().m_5565_(false);
                        break;
                    }
                    if (sunProEntity == null) break;
                    sunProEntity.m_5602_((Entity)player);
                    sunProEntity.m_6034_(player.m_20185_(), player.m_20188_() + 0.1, player.m_20189_());
                    sunProEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                    level.m_7967_((Entity)sunProEntity);
                    level.m_5594_(player, player.m_20097_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
                    break;
                }
                case 2: {
                    RainProEntity rainProEntity = (RainProEntity)((EntityType)ModEntities.RAIN_PRO.get()).m_20615_(level);
                    if (pitch <= -85.0f && level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        level.m_6106_().m_5565_(true);
                        server.m_8606_(0, duration, true, false);
                        break;
                    }
                    if (rainProEntity == null) break;
                    rainProEntity.m_5602_((Entity)player);
                    rainProEntity.m_6034_(player.m_20185_(), player.m_20188_() + 0.1, player.m_20189_());
                    rainProEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                    level.m_7967_((Entity)rainProEntity);
                    break;
                }
                case 3: {
                    StormProEntity stormProEntity = (StormProEntity)((EntityType)ModEntities.STORM_PRO.get()).m_20615_(level);
                    if (pitch <= -85.0f && level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        level.m_6106_().m_5565_(true);
                        server.m_8606_(0, duration, true, true);
                        break;
                    }
                    if (stormProEntity == null) break;
                    stormProEntity.m_5602_((Entity)player);
                    stormProEntity.m_6034_(player.m_20185_(), player.m_20188_() + 0.1, player.m_20189_());
                    stormProEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                    level.m_7967_((Entity)stormProEntity);
                }
            }
            player.m_21011_(hand, true);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.cycleMode(world, player, hand, MODES);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        this.onUse(world, player, stack, hand);
        return super.m_7203_(world, player, hand);
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pLevel.f_46443_ && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pIsSelected) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, -1, 0, false, false));
            } else {
                player.m_21195_(MobEffects.f_19591_);
            }
        }
    }
}

