/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.common.entity.EndestPearlEntity;
import committee.nova.mods.avaritia.common.entity.TNTProEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityCrossBowItem
extends CrossbowItem
implements InitEnchantItem,
ISwitchable,
IUndamageable,
IBowTransform {
    public InfinityCrossBowItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(ModRarities.COSMIC).m_41486_());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)ModTooltips.INIT_ENCHANT.args(Enchantments.f_44952_.m_44700_(10)).build());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.switchMode(level, player, hand, "infinity_crossbow_multi");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (InfinityCrossBowItem.m_40932_((ItemStack)stack)) {
            this.performShooting(level, player, hand, stack, 1.0f, 1.0f);
            InfinityCrossBowItem.m_40884_((ItemStack)stack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!level.f_46443_) {
            InfinityCrossBowItem.m_40884_((ItemStack)stack, (boolean)true);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        InfinityCrossBowItem.m_40884_((ItemStack)stack, (boolean)true);
    }

    private void performShooting(Level level, Player player, InteractionHand hand, ItemStack crossbow, float velocity, float inaccuracy) {
        float[] fArray;
        int projectileCount;
        if (level.f_46443_) {
            return;
        }
        ItemStack ammo = this.findAmmo(player);
        boolean isMulti = this.isActive(crossbow, "infinity_crossbow_multi");
        int n = projectileCount = isMulti ? 5 : 1;
        if (isMulti) {
            float[] fArray2 = new float[5];
            fArray2[0] = -20.0f;
            fArray2[1] = -10.0f;
            fArray2[2] = 0.0f;
            fArray2[3] = 10.0f;
            fArray = fArray2;
            fArray2[4] = 20.0f;
        } else {
            float[] fArray3 = new float[1];
            fArray = fArray3;
            fArray3[0] = 0.0f;
        }
        float[] angles = fArray;
        for (int i = 0; i < projectileCount; ++i) {
            float angle = angles[Math.min(i, angles.length - 1)];
            if (!ammo.m_41619_()) {
                this.shootBasedOnAmmo(level, player, ammo, angle);
                continue;
            }
            this.shootInfnityArrow(level, player, 3.0f, 1.0f, angle);
        }
    }

    private void shootBasedOnAmmo(Level level, Player player, ItemStack ammo, float angle) {
        if (ammo.m_150930_(Items.f_42412_)) {
            this.shootArrow(level, player, 3.0f, 1.0f, angle);
        } else if (ammo.m_150930_(Items.f_42584_)) {
            this.shootEnderPearl(level, player, angle);
        } else if (ammo.m_150930_(Items.f_42613_)) {
            this.shootFireball(level, player, angle);
        } else if (ammo.m_150930_(Items.f_42737_)) {
            this.shootSpectralArrow(level, player, 3.0f, 1.0f, angle);
        } else if (ammo.m_150930_(Items.f_42738_)) {
            this.shootTippedArrow(level, player, ammo, 3.0f, 1.0f, angle);
        } else if (ammo.m_150930_(Items.f_42688_)) {
            this.shootFireworkRocket(level, player, ammo, 3.0f, 1.0f, angle);
        } else if (ammo.m_150930_(Items.f_42713_)) {
            this.shootTrident(level, player, ammo, 3.0f, 1.0f, angle);
        } else if (ammo.m_150930_(Items.f_42452_)) {
            this.shootSnowball(level, player, angle);
        } else if (ammo.m_150930_(Items.f_42521_)) {
            this.shootEgg(level, player, angle);
        } else if (ammo.m_150930_((Item)ModItems.endest_pearl.get())) {
            this.shootEndestPearl(level, player, angle);
        } else if (ammo.m_150930_(Items.f_41996_)) {
            this.shootTNT(level, player, angle);
        } else {
            this.shootInfnityArrow(level, player, 3.0f, 1.0f, angle);
        }
    }

    private ItemStack findAmmo(Player player) {
        if (this.isAmmo(player.m_21206_())) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    private boolean isAmmo(ItemStack stack) {
        return stack.m_150930_(Items.f_42412_) || stack.m_150930_(Items.f_42584_) || stack.m_150930_(Items.f_42613_) || stack.m_150930_(Items.f_42737_) || stack.m_150930_(Items.f_42738_) || stack.m_150930_(Items.f_42688_) || stack.m_150930_(Items.f_42713_) || stack.m_150930_(Items.f_42452_) || stack.m_150930_(Items.f_42521_) || stack.m_150930_((Item)ModItems.endest_pearl.get()) || stack.m_150930_(Items.f_41996_);
    }

    private void shootInfnityArrow(Level level, Player player, float velocity, float inaccuracy, float angle) {
        HeavenArrowEntity arrow = new HeavenArrowEntity(level, (Entity)player);
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, velocity, inaccuracy);
        level.m_7967_((Entity)arrow);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootArrow(Level level, Player player, float velocity, float inaccuracy, float angle) {
        Arrow arrow = new Arrow(level, (LivingEntity)player);
        arrow.m_36878_(new ItemStack((ItemLike)Items.f_42412_));
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, velocity, inaccuracy);
        level.m_7967_((Entity)arrow);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootEnderPearl(Level level, Player player, float angle) {
        ThrownEnderpearl pearl = new ThrownEnderpearl(level, (LivingEntity)player);
        pearl.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)pearl);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11857_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootFireball(Level level, Player player, float angle) {
        SmallFireball fireball = new SmallFireball(level, (LivingEntity)player, player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_);
        fireball.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
        fireball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, 1.0f, 1.0f);
        level.m_7967_((Entity)fireball);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootSpectralArrow(Level level, Player player, float velocity, float inaccuracy, float angle) {
        SpectralArrow arrow = new SpectralArrow(level, (LivingEntity)player);
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, velocity, inaccuracy);
        level.m_7967_((Entity)arrow);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootTippedArrow(Level level, Player player, ItemStack ammo, float velocity, float inaccuracy, float angle) {
        Arrow arrow = new Arrow(level, (LivingEntity)player);
        arrow.m_36878_(ammo);
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, velocity, inaccuracy);
        level.m_7967_((Entity)arrow);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootFireworkRocket(Level level, Player player, ItemStack fireworkItem, float velocity, float inaccuracy, float angle) {
        FireworkRocketEntity firework = new FireworkRocketEntity(level, fireworkItem, (Entity)player, player.m_20185_(), player.m_20188_(), player.m_20189_(), true);
        Vec3 lookVec = player.m_20154_();
        if (angle != 0.0f) {
            lookVec = lookVec.m_82524_((float)Math.toRadians(angle));
        }
        Vec3 motion = lookVec.m_82490_((double)velocity);
        if (inaccuracy > 0.0f) {
            motion = motion.m_82520_(level.f_46441_.m_188583_() * (double)0.0075f * (double)inaccuracy, level.f_46441_.m_188583_() * (double)0.0075f * (double)inaccuracy, level.f_46441_.m_188583_() * (double)0.0075f * (double)inaccuracy);
        }
        firework.m_20256_(motion);
        firework.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
        level.m_7967_((Entity)firework);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11933_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootTrident(Level level, Player player, ItemStack trident, float velocity, float inaccuracy, float angle) {
        ThrownTrident tridentEntity = new ThrownTrident(level, (LivingEntity)player, trident);
        tridentEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, velocity, inaccuracy);
        level.m_7967_((Entity)tridentEntity);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootSnowball(Level level, Player player, float angle) {
        Snowball snowball = new Snowball(level, (LivingEntity)player);
        snowball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)snowball);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootEgg(Level level, Player player, float angle) {
        ThrownEgg egg = new ThrownEgg(level, (LivingEntity)player);
        egg.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)egg);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11877_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootEndestPearl(Level level, Player player, float angle) {
        EndestPearlEntity pearl = new EndestPearlEntity(level, (LivingEntity)player);
        pearl.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + angle, 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)pearl);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11857_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void shootTNT(Level level, Player player, float angle) {
        TNTProEntity tnt = new TNTProEntity(level, player.m_20185_(), player.m_20188_(), player.m_20189_(), (LivingEntity)player);
        Vec3 lookVec = player.m_20154_();
        if (angle != 0.0f) {
            lookVec = lookVec.m_82524_((float)Math.toRadians(angle));
        }
        tnt.m_20256_(lookVec.m_82490_(1.5));
        level.m_7967_((Entity)tnt);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12512_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44952_ ? 10 : 0;
    }
}

