/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.common.entity.InfinityThrownTrident;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InfinityTridentItem
extends TridentItem
implements IUndamageable,
ISwitchable {
    public static final List<String> FUNC_MODES = Arrays.asList("infinity_trident_normal", "infinity_trident_loyalty", "infinity_trident_riptide");
    public static final byte MODE_NORMAL = 0;
    public static final byte MODE_LOYALTY = 1;
    public static final byte MODE_RIPTIDE = 2;
    private static final String CHANNELING_NBT = "Channeling";
    private static final String SHOCKWAVE_NBT = "Shockwave";

    public InfinityTridentItem() {
        super(new Item.Properties().m_41497_(ModRarities.COSMIC).m_41487_(1).m_41486_());
    }

    public boolean getCurrentChanneling(ItemStack stack) {
        return stack.m_41784_().m_128471_(CHANNELING_NBT);
    }

    public void setChanneling(ItemStack stack, boolean enabled) {
        stack.m_41784_().m_128379_(CHANNELING_NBT, enabled);
    }

    public boolean getCurrentShockwave(ItemStack stack) {
        return stack.m_41784_().m_128471_(SHOCKWAVE_NBT);
    }

    public void setShockwave(ItemStack stack, boolean enabled) {
        stack.m_41784_().m_128379_(SHOCKWAVE_NBT, enabled);
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 18000;
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int i = this.m_8105_(itemStack) - timeLeft;
            int currentMode = ISwitchable.getCurrentMode(itemStack, FUNC_MODES);
            if (i >= 10) {
                switch (currentMode) {
                    case 0: {
                        this.shootTrident(itemStack, level, player, true);
                        break;
                    }
                    case 1: {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        this.shootTrident(itemStack, level, player, false);
                        break;
                    }
                    case 2: {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        int riptideLevel = 5;
                        float toRadians = (float)Math.PI / 180;
                        float yaw = player.m_146908_() * toRadians;
                        float pitch = player.m_146909_() * toRadians;
                        float xVelocity = -Mth.m_14031_((float)yaw) * Mth.m_14089_((float)pitch);
                        float yVelocity = -Mth.m_14031_((float)pitch);
                        float zVelocity = Mth.m_14089_((float)yaw) * Mth.m_14089_((float)pitch);
                        float velocity = Mth.m_14116_((float)(xVelocity * xVelocity + yVelocity * yVelocity + zVelocity * zVelocity));
                        float velocityModifier = (0.75f + 0.75f * (float)riptideLevel) / velocity;
                        player.m_5997_((double)(xVelocity * velocityModifier), (double)(yVelocity * velocityModifier), (double)(zVelocity * velocityModifier));
                        player.m_204079_(20);
                        if (player.m_20096_()) {
                            player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                        }
                        level.m_6269_(null, (Entity)player, SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private void shootTrident(@NotNull ItemStack itemStack, @NotNull Level level, Player player, boolean noReturn) {
        if (!level.f_46443_) {
            InfinityThrownTrident throwntrident = new InfinityThrownTrident(level, (LivingEntity)player, itemStack);
            throwntrident.setLoyaltyLevel(noReturn ? 0 : 3);
            throwntrident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
            if (player.m_150110_().f_35937_) {
                throwntrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.m_7967_((Entity)throwntrident);
            level.m_6269_(null, (Entity)throwntrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                player.m_150109_().m_36057_(itemStack);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.cycleMode(world, player, hand, FUNC_MODES);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }
}

