/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.CollectorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronCollectorTile
extends BaseInventoryTileEntity {
    public final ItemStackWrapper inventory;
    public SimpleContainerData data = new SimpleContainerData(1);
    private int progress;
    private CollectorTier tier;

    public NeutronCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_collector_tile.get(), pos, state);
        this.inventory = NeutronCollectorTile.createInventoryHandler();
        if (state.m_60713_((Block)ModBlocks.neutron_collector.get())) {
            this.tier = CollectorTier.DEFAULT;
        } else if (state.m_60713_((Block)ModBlocks.dense_neutron_collector.get())) {
            this.tier = CollectorTier.DENSE;
        } else if (state.m_60713_((Block)ModBlocks.denser_neutron_collector.get())) {
            this.tier = CollectorTier.DENSER;
        } else if (state.m_60713_((Block)ModBlocks.densest_neutron_collector.get())) {
            this.tier = CollectorTier.DENSEST;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NeutronCollectorTile tile) {
        if (tile.canWork()) {
            ItemStack result = tile.inventory.getStackInSlot(0);
            ItemStack stack = tile.tier.production.m_43908_()[0];
            ++tile.progress;
            tile.data.m_8050_(0, tile.progress);
            if (tile.progress >= tile.tier.production_ticks) {
                if (result.m_41619_()) {
                    tile.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else if (result.m_150930_(stack.m_41720_()) && result.m_41613_() < 64) {
                    tile.inventory.setStackInSlot(0, ItemUtils.grow(result, 1));
                }
                tile.progress = 0;
                tile.setChangedAndDispatch();
            }
        }
    }

    public static ItemStackWrapper createInventoryHandler() {
        ItemStackWrapper inventory = new ItemStackWrapper(1, Integer.MAX_VALUE);
        inventory.setOutputSlots(0);
        return inventory;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    protected boolean canWork() {
        return this.inventory.getStackInSlot(0).m_41619_() || this.inventory.getStackInSlot(0).m_41613_() < 64;
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new NeutronCollectorMenu(windowId, playerInventory, this.m_58899_(), (ContainerData)this.data);
    }

    public CollectorTier getTier() {
        return this.tier;
    }

    public void setTier(CollectorTier tier) {
        this.tier = tier;
    }

    public int getProductionTicks() {
        return this.tier.production_ticks;
    }

    public Item getProduction() {
        return this.tier.production.m_43908_()[0].m_41720_();
    }
}

