/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.tile.BaseTileEntity;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.TesseractMenu;
import committee.nova.mods.avaritia.common.net.channel.ChannelAction;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelActionPack;
import committee.nova.mods.avaritia.core.channel.ChannelInfo;
import committee.nova.mods.avaritia.core.channel.IChannelTerminal;
import committee.nova.mods.avaritia.core.channel.NullChannel;
import committee.nova.mods.avaritia.core.channel.ServerChannel;
import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import java.util.HashSet;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TesseractTile
extends BaseTileEntity
implements IChannelTerminal {
    private final int slotIndex;
    private UUID owner;
    private boolean locked = false;
    private boolean craftingMode = false;
    private String filter = "";
    private byte sortType = (byte)4;
    private byte viewType = 0;
    private UUID channelOwner;
    private int channelID = -1;
    private boolean waterlogged = false;
    private final HashSet<ServerPlayer> channelSelectors = new HashSet();
    private ServerChannel channel = NullChannel.INSTANCE;
    private LazyOptional<?> capability = LazyOptional.of(() -> this.channel);

    public TesseractTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.tesseract_tile.get(), pos, state);
        this.slotIndex = -2;
        this.onBlockStateChange();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TesseractTile blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.channel.isRemoved()) {
            if (blockEntity.channelID >= 0) {
                blockEntity.setChannel(null, -1);
            }
        } else if (blockEntity.waterlogged) {
            blockEntity.channel.addFluid(new FluidStack((Fluid)Fluids.f_76193_, 1000));
        }
    }

    public void onBlockStateChange() {
        BlockState state = this.m_58900_();
        this.waterlogged = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        if (pTag.m_128441_("owner")) {
            this.owner = pTag.m_128342_("owner");
            this.locked = pTag.m_128471_("locked");
        }
        if (pTag.m_128441_("craftingMode")) {
            this.craftingMode = pTag.m_128471_("craftingMode");
        }
        if (pTag.m_128441_("filter")) {
            this.filter = pTag.m_128461_("filter");
        }
        if (pTag.m_128441_("sortType")) {
            this.sortType = pTag.m_128445_("sortType");
        }
        if (pTag.m_128441_("viewType")) {
            this.viewType = pTag.m_128445_("viewType");
        }
        if (pTag.m_128441_("channel")) {
            CompoundTag channel = pTag.m_128469_("channel");
            this.channelOwner = channel.m_128342_("channelOwner");
            this.channelID = channel.m_128451_("channelID");
        }
        this.channel = ServerChannelManager.getInstance().getChannel(this.channelOwner, this.channelID);
    }

    public void m_183515_(@NotNull CompoundTag pTag) {
        if (this.owner != null) {
            pTag.m_128362_("owner", this.owner);
            pTag.m_128379_("locked", this.locked);
        }
        pTag.m_128379_("craftingMode", this.craftingMode);
        pTag.m_128359_("filter", this.filter);
        pTag.m_128344_("sortType", this.sortType);
        pTag.m_128344_("viewType", this.viewType);
        if (this.channelID >= 0) {
            CompoundTag channel = new CompoundTag();
            channel.m_128362_("channelOwner", this.channelOwner);
            channel.m_128405_("channelID", this.channelID);
            pTag.m_128365_("channel", (Tag)channel);
        }
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, @NotNull Player pPlayer) {
        return new TesseractMenu(pContainerId, pInventory.f_35978_, this, this.slotIndex);
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("block.avaritia.infinity_chest").build();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.channel.isRemoved()) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER || cap == ForgeCapabilities.FLUID_HANDLER || cap == ForgeCapabilities.ENERGY) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public UUID getTerminalOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public ChannelInfo getChannelInfo() {
        if (this.channelID >= 0) {
            return new ChannelInfo(this.channelOwner, this.channelID);
        }
        return null;
    }

    @Override
    public void setChannel(UUID channelOwner, int channelID) {
        this.channelOwner = channelOwner;
        this.channelID = channelID;
        this.m_6596_();
        this.channelSelectors.forEach(player -> ServerChannelManager.sendChannelSet(player, this.owner, channelOwner, channelID));
        this.channel = ServerChannelManager.getInstance().getChannel(channelOwner, channelID);
        this.capability = LazyOptional.of(() -> this.channel);
    }

    @Override
    public void removeChannel(ServerPlayer actor) {
        if (this.channelOwner == null) {
            return;
        }
        if (this.channelOwner.equals(actor.m_20148_()) || this.channelOwner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            if (!ServerChannelManager.getInstance().tryRemoveChannel(this.channelOwner, this.channelID)) {
                return;
            }
            this.channelID = -1;
            this.channelOwner = null;
            this.m_6596_();
            this.channelSelectors.forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.SET, -1, "", -1)));
            this.channel = NullChannel.INSTANCE;
        }
    }

    @Override
    public void renameChannel(ServerPlayer actor, String name) {
        if (this.channelID < 0) {
            return;
        }
        if (actor.m_20148_().equals(this.channelOwner) || this.channelOwner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            ServerChannelManager.getInstance().renameChannel(new ChannelInfo(this.channelOwner, this.channelID), name);
        }
    }

    @Override
    public void addChannelSelector(ServerPlayer player) {
        this.channelSelectors.add(player);
        if (this.channelID < 0) {
            return;
        }
        ServerChannelManager.sendChannelSet(player, this.owner, this.channelOwner, this.channelID);
    }

    @Override
    public void removeChannelSelector(ServerPlayer player) {
        this.channelSelectors.remove(player);
    }

    @Override
    public boolean stillValid() {
        return !this.m_58901_();
    }

    @Override
    public void tryReOpenMenu(ServerPlayer player) {
        if (this.channelID >= 0) {
            this.m_58900_().m_60664_(this.f_58857_, (Player)player, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5), Direction.UP, this.f_58858_, false));
        }
    }

    public void inhaleItem(ItemEntity itemEntity) {
        if (this.channel.isRemoved()) {
            return;
        }
        ItemStack itemStack = itemEntity.m_32055_();
        this.channel.addItem(itemStack);
        if (!itemStack.m_41619_()) {
            BlockPos blockPos = this.m_58899_();
            itemEntity.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() - 0.26, (double)blockPos.m_123343_() + 0.5);
            itemEntity.m_20334_(0.0, -0.1, 0.0);
        }
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.m_6596_();
    }

    public void setCraftingMode(Boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.m_6596_();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.m_6596_();
    }

    public void setSortType(byte sortType) {
        this.sortType = sortType;
        this.m_6596_();
    }

    public void setViewType(byte viewType) {
        this.viewType = viewType;
        this.m_6596_();
    }

    public void setChannelOwner(UUID owner) {
        this.channelOwner = owner;
        this.m_6596_();
    }

    public void setChannelId(int id) {
        this.channelID = id;
        this.m_6596_();
    }

    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public byte getSortType() {
        return this.sortType;
    }

    @Generated
    public byte getViewType() {
        return this.viewType;
    }

    @Generated
    public UUID getChannelOwner() {
        return this.channelOwner;
    }

    @Generated
    public int getChannelID() {
        return this.channelID;
    }

    @Generated
    public ServerChannel getChannel() {
        return this.channel;
    }

    @Generated
    public LazyOptional<?> getCapability() {
        return this.capability;
    }
}

