/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.wrappers;

import committee.nova.mods.avaritia.Const;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InfiniteItemHandler
implements IItemHandler,
IItemHandlerModifiable {
    public static final int SLOTS_PER_PAGE = 54;
    public static final int MAX_PAGES = 1000000;
    public static final int MAX_ITEMS = 1000000;
    private final List<ItemStack> items;
    private int scrollPosition = 0;
    private String searchQuery = "";
    private SortType sortType = SortType.NONE;
    private Map<String, List<ItemStack>> modItemsMap;
    private boolean rebuildModMap = true;

    public InfiniteItemHandler() {
        this.items = new ArrayList<ItemStack>();
        this.initializeSlots();
    }

    private void initializeSlots() {
        while (this.items.size() < 54) {
            this.items.add(ItemStack.f_41583_);
        }
    }

    public int getSlots() {
        return 54;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int actualSlot = this.scrollPosition + slot;
        if (actualSlot < 0 || actualSlot >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return this.items.get(actualSlot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int i;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.getNonEmptyItemCount() >= 1000000) {
            return stack;
        }
        for (i = 0; i < this.items.size(); ++i) {
            int spaceLeft;
            ItemStack existing = this.items.get(i);
            if (existing.m_41619_() || !ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack) || (spaceLeft = existing.m_41741_() - existing.m_41613_()) <= 0) continue;
            int amountToInsert = Math.min(stack.m_41613_(), spaceLeft);
            if (!simulate) {
                existing.m_41769_(amountToInsert);
                this.rebuildModMap = true;
            }
            return stack.m_255036_(stack.m_41613_() - amountToInsert);
        }
        for (i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).m_41619_()) continue;
            int amountToInsert = Math.min(stack.m_41613_(), stack.m_41741_());
            if (!simulate) {
                this.items.set(i, stack.m_255036_(amountToInsert));
                this.rebuildModMap = true;
            }
            return stack.m_255036_(stack.m_41613_() - amountToInsert);
        }
        if (this.items.size() < 1000000) {
            int amountToInsert = Math.min(stack.m_41613_(), stack.m_41741_());
            if (!simulate) {
                this.items.add(stack.m_255036_(amountToInsert));
                this.rebuildModMap = true;
            }
            return stack.m_255036_(stack.m_41613_() - amountToInsert);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        int actualSlot = this.scrollPosition + slot;
        if (actualSlot < 0 || actualSlot >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.items.get(actualSlot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int amountToExtract = Math.min(amount, existing.m_41613_());
        ItemStack extracted = existing.m_255036_(amountToExtract);
        if (!simulate) {
            existing.m_41774_(amountToExtract);
            if (existing.m_41619_()) {
                this.items.set(actualSlot, ItemStack.f_41583_);
            }
            this.rebuildModMap = true;
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int actualSlot = this.scrollPosition + slot;
        while (actualSlot >= this.items.size()) {
            this.items.add(ItemStack.f_41583_);
        }
        this.items.set(actualSlot, stack);
        this.rebuildModMap = true;
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(int position) {
        this.scrollPosition = Math.max(0, Math.min(position, Math.max(0, this.items.size() - 54)));
    }

    public int getMaxScrollPosition() {
        return Math.max(0, this.items.size() - 54);
    }

    public int getNonEmptyItemCount() {
        int count = 0;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public void setSearchQuery(String query) {
        this.searchQuery = query.toLowerCase();
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public List<ItemStack> getFilteredItems() {
        if (this.searchQuery.isEmpty()) {
            return new ArrayList<ItemStack>(this.items);
        }
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_() || !stack.m_41611_().getString().toLowerCase().contains(this.searchQuery)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    public void setSortType(SortType type) {
        this.sortType = type;
        if (type != SortType.NONE) {
            this.sortItems();
        }
    }

    public SortType getSortType() {
        return this.sortType;
    }

    private void sortItems() {
        ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            nonEmptyItems.add(stack);
        }
        nonEmptyItems.sort((stack1, stack2) -> {
            switch (this.sortType) {
                case NAME: {
                    return stack1.m_41611_().getString().compareTo(stack2.m_41611_().getString());
                }
                case COUNT: {
                    return Integer.compare(stack2.m_41613_(), stack1.m_41613_());
                }
                case MOD: {
                    String modId1 = Const.getItemName(stack1.m_41720_()).m_135827_();
                    String modId2 = Const.getItemName(stack2.m_41720_()).m_135827_();
                    return modId1.compareTo(modId2);
                }
                case CATEGORY: {
                    return stack1.m_41720_().m_41466_().getString().compareTo(stack2.m_41720_().m_41466_().getString());
                }
            }
            return 0;
        });
        this.items.clear();
        this.items.addAll(nonEmptyItems);
        this.initializeSlots();
        this.rebuildModMap = true;
    }

    public Map<String, List<ItemStack>> getItemsByMod() {
        if (this.rebuildModMap || this.modItemsMap == null) {
            this.rebuildModItemsMap();
        }
        return this.modItemsMap;
    }

    private void rebuildModItemsMap() {
        this.modItemsMap = new HashMap<String, List<ItemStack>>();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            String modId = Const.getItemName(stack.m_41720_()).m_135827_();
            this.modItemsMap.computeIfAbsent(modId, k -> new ArrayList()).add(stack);
        }
        this.rebuildModMap = false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag itemsList = new ListTag();
        for (ItemStack stack : this.items) {
            CompoundTag itemTag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(itemTag);
            }
            itemsList.add((Object)itemTag);
        }
        tag.m_128365_("Items", (Tag)itemsList);
        tag.m_128405_("ScrollPosition", this.scrollPosition);
        tag.m_128359_("SearchQuery", this.searchQuery);
        tag.m_128359_("SortType", this.sortType.name());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.items.clear();
        ListTag itemsList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag itemTag = itemsList.m_128728_(i);
            if (itemTag.m_128456_()) {
                this.items.add(ItemStack.f_41583_);
                continue;
            }
            this.items.add(ItemStack.m_41712_((CompoundTag)itemTag));
        }
        this.scrollPosition = nbt.m_128451_("ScrollPosition");
        this.searchQuery = nbt.m_128461_("SearchQuery");
        this.sortType = SortType.valueOf(nbt.m_128461_("SortType"));
        this.rebuildModMap = true;
    }

    public List<ItemStack> getAllItems() {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            allItems.add(stack);
        }
        return allItems;
    }

    public static enum SortType {
        NONE,
        NAME,
        COUNT,
        MOD,
        CATEGORY;

    }
}

