/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.wrappers;

import committee.nova.mods.avaritia.common.item.misc.InfinityBucketItem;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    @NotNull
    private final ItemStack container;
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);

    public InfinityBucketWrapper(@NotNull ItemStack container) {
        this.container = container;
    }

    public int getTanks() {
        return Math.max(InfinityBucketItem.getFluids(this.container).size(), 1);
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return InfinityBucketItem.getFluids(this.container).stream().skip(tank).findFirst().orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int fillAmount;
        if (this.container.m_41613_() != 1 && resource.isEmpty()) {
            return 0;
        }
        List<FluidStack> fluids = InfinityBucketItem.getFluids(this.container);
        FluidStack contained = fluids.stream().filter(fluid -> fluid.isFluidEqual(resource)).findFirst().orElse(FluidStack.EMPTY);
        if (contained.isEmpty()) {
            fillAmount = resource.getAmount();
            FluidStack filled = resource.copy();
            filled.setAmount(fillAmount);
            fluids.add(0, filled);
        } else {
            fillAmount = Math.min(Integer.MAX_VALUE - contained.getAmount(), resource.getAmount());
            contained.grow(fillAmount);
            fluids.remove(contained);
            fluids.add(0, contained);
        }
        if (action.execute()) {
            InfinityBucketItem.setFluids(this.container, fluids);
        }
        return fillAmount;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack firstContained = InfinityBucketItem.getFluids(this.container).stream().findFirst().orElse(FluidStack.EMPTY);
        if (!resource.isFluidEqual(firstContained)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        List<FluidStack> fluids = InfinityBucketItem.getFluids(this.container);
        FluidStack firstContained = fluids.stream().findFirst().orElse(FluidStack.EMPTY);
        if (firstContained.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drainAmount = Math.min(firstContained.getAmount(), maxDrain);
        FluidStack drained = firstContained.copy();
        drained.setAmount(drainAmount);
        firstContained.shrink(drainAmount);
        if (firstContained.isEmpty()) {
            fluids.remove(firstContained);
        }
        if (action.execute()) {
            InfinityBucketItem.setFluids(this.container, fluids);
        }
        return drained;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, this.holder);
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }
}

