/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.wrappers;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageItem {
    public static final StorageItem EMPTY = new StorageItem(ItemStack.f_41583_, 0L);
    private boolean empty;
    private final ItemStack stack;
    private long count;

    private StorageItem(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    private StorageItem(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
        this.count = Integer.toUnsignedLong(nbt.m_128451_("Count"));
    }

    public static StorageItem create(ItemStack stack, int count) {
        if (!stack.m_41619_() && count != 0) {
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            StorageItem container = new StorageItem(copy, count);
            container.updateEmptyState();
            return container;
        }
        return EMPTY;
    }

    public static StorageItem create(ItemStack stack) {
        return StorageItem.create(stack, stack.m_41613_());
    }

    public static StorageItem read(CompoundTag nbt) {
        StorageItem container = new StorageItem(nbt);
        container.updateEmptyState();
        return container;
    }

    private void updateEmptyState() {
        this.empty = this.isEmpty();
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.stack.m_41619_()) {
            return true;
        }
        return this.count <= 0L;
    }

    public ItemStack getStack() {
        return this.empty ? ItemStack.f_41583_ : this.stack;
    }

    public long getCount() {
        return this.empty ? 0L : this.count;
    }

    public void setCount(long count) {
        this.count = count;
        this.updateEmptyState();
    }

    public void grow(long count) {
        this.setCount(this.count + count);
    }

    public void shrink(long count) {
        this.grow(-count);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Stack", (Tag)this.stack.serializeNBT());
        nbt.m_128405_("Count", (int)this.count);
        return nbt;
    }
}

