/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.HashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class Channel
implements IItemHandler,
IFluidHandler,
IEnergyStorage {
    private String channelName = "UnName";
    public final HashMap<String, Long> storageItems = new HashMap();
    public final HashMap<String, Long> storageFluids = new HashMap();
    public final HashMap<String, Long> storageEnergies = new HashMap();
    private String[] itemKeys = new String[0];
    private String[] fluidKeys = new String[0];
    private ItemStack[] slotItemTemp = new ItemStack[]{ItemStack.f_41583_};
    private FluidStack[] slotFluidTemp = new FluidStack[]{FluidStack.EMPTY};
    public final int maxChannelSize = 2000;

    public void onItemChanged(String itemId, boolean listChanged) {
        if (listChanged) {
            this.updateItemKeys();
        }
    }

    public void onFluidChanged(String fluidId, boolean listChanged) {
        if (listChanged) {
            this.updateFluidKeys();
        }
    }

    public abstract void onEnergyChanged(String var1, boolean var2);

    public void updateItemKeys() {
        this.itemKeys = this.storageItems.keySet().toArray(new String[0]);
        this.slotItemTemp = new ItemStack[this.itemKeys.length];
        for (int i = 0; i < this.itemKeys.length; ++i) {
            this.slotItemTemp[i] = new ItemStack((ItemLike)StorageUtils.getItem(this.itemKeys[i]));
        }
    }

    public void updateFluidKeys() {
        this.fluidKeys = this.storageFluids.keySet().toArray(new String[0]);
        this.slotFluidTemp = new FluidStack[this.fluidKeys.length];
        for (int i = 0; i < this.fluidKeys.length; ++i) {
            this.slotFluidTemp[i] = new FluidStack(StorageUtils.getFluid(this.fluidKeys[i]), 1);
        }
    }

    public int getChannelSize() {
        return this.storageItems.size() + this.storageFluids.size() + this.storageEnergies.size();
    }

    public boolean hasItem(String item) {
        return this.storageItems.containsKey(item);
    }

    public int getItemAmount(String item) {
        return (int)Long.min(Integer.MAX_VALUE, this.storageItems.getOrDefault(item, 0L));
    }

    public long getRealItemAmount(String item) {
        return this.storageItems.getOrDefault(item, 0L);
    }

    public int getFluidAmount(String fluid) {
        return (int)Long.min(Integer.MAX_VALUE, this.storageFluids.getOrDefault(fluid, 0L));
    }

    public long getRealFluidAmount(String fluid) {
        return this.storageFluids.getOrDefault(fluid, 0L);
    }

    public int getFEAmount() {
        return (int)Long.min(Integer.MAX_VALUE, this.storageEnergies.getOrDefault("avaritia:forge_energy", 0L));
    }

    public long getRealFEAmount() {
        return this.storageEnergies.getOrDefault("avaritia:forge_energy", 0L);
    }

    public int getStorageEnergy(String energyId) {
        return (int)Long.min(Integer.MAX_VALUE, this.storageEnergies.getOrDefault(energyId, 0L));
    }

    public long getRealEnergyAmount(String energyId) {
        return this.storageEnergies.getOrDefault(energyId, 0L);
    }

    public int getStorageAmount(Item item) {
        return (int)Long.min(Integer.MAX_VALUE, this.storageItems.getOrDefault(StorageUtils.getItemId(item), 0L));
    }

    public int getStorageAmount(Fluid fluid) {
        return (int)Long.min(Integer.MAX_VALUE, this.storageFluids.getOrDefault(StorageUtils.getFluidId(fluid), 0L));
    }

    public int canStorageAmount(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return 0;
        }
        long a = this.storageItems.getOrDefault(StorageUtils.getItemId(itemStack.m_41720_()), 0L);
        if (a == 0L) {
            if (this.getChannelSize() >= 2000) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public int canStorageAmount(FluidStack fluidStack) {
        if (fluidStack.hasTag()) {
            return 0;
        }
        long a = this.storageFluids.getOrDefault(StorageUtils.getFluidId(fluidStack.getFluid()), 0L);
        if (a == 0L) {
            if (this.getChannelSize() >= 2000) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public long canStorageRealAmount(FluidStack fluidStack) {
        if (fluidStack.hasTag()) {
            return 0L;
        }
        long a = this.storageFluids.getOrDefault(StorageUtils.getFluidId(fluidStack.getFluid()), 0L);
        if (a == 0L) {
            if (this.getChannelSize() >= 2000) {
                return 0L;
            }
            return Long.MAX_VALUE;
        }
        return Long.MAX_VALUE - a;
    }

    public boolean canStorageItem(String item) {
        if (this.storageItems.containsKey(item)) {
            return this.storageItems.get(item) < Long.MAX_VALUE;
        }
        return this.getChannelSize() < 2000;
    }

    public int canStorageItemAmount(String item) {
        long a = this.storageItems.getOrDefault(item, 0L);
        if (a == 0L) {
            if (this.getChannelSize() >= 2000) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public int canStorageFluidAmount(String fluidId) {
        long a = this.storageFluids.getOrDefault(fluidId, 0L);
        if (a == 0L) {
            if (this.getChannelSize() >= 2000) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public boolean canStorageFE() {
        if (this.storageEnergies.containsKey("avaritia:forge_energy")) {
            return this.storageEnergies.get("avaritia:forge_energy") < Long.MAX_VALUE;
        }
        return this.getChannelSize() < 2000;
    }

    public int canStorageFEAmount() {
        long a = this.storageEnergies.getOrDefault("avaritia:forge_energy", 0L);
        if (a == 0L) {
            if (this.getChannelSize() >= 2000) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(Integer.MAX_VALUE, Long.MAX_VALUE - a);
    }

    public String[] getItemKeys() {
        return this.itemKeys;
    }

    public String[] getFluidKeys() {
        return this.fluidKeys;
    }

    public int addItem(ItemStack itemStack) {
        if (itemStack.m_41782_() || itemStack.m_41619_()) {
            return 0;
        }
        String itemId = StorageUtils.getItemId(itemStack.m_41720_());
        int count = itemStack.m_41613_();
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if (remainingSpaces >= (long)itemStack.m_41613_()) {
                this.storageItems.replace(itemId, storageCount + (long)itemStack.m_41613_());
                itemStack.m_41764_(0);
                this.onItemChanged(itemId, false);
                return count;
            }
            this.storageItems.replace(itemId, Long.MAX_VALUE);
            itemStack.m_41764_(itemStack.m_41613_() - (int)remainingSpaces);
            this.onItemChanged(itemId, false);
            return (int)remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0;
        }
        this.storageItems.put(itemId, Long.valueOf(itemStack.m_41613_()));
        itemStack.m_41764_(0);
        this.onItemChanged(itemId, true);
        return count;
    }

    public int addFluid(FluidStack fluidStack) {
        if (fluidStack.hasTag() || fluidStack.isEmpty()) {
            return 0;
        }
        String fluidId = StorageUtils.getFluidId(fluidStack.getFluid());
        int count = fluidStack.getAmount();
        if (this.storageFluids.containsKey(fluidId)) {
            long storageAmount = this.storageFluids.get(fluidId);
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= (long)fluidStack.getAmount()) {
                this.storageFluids.replace(fluidId, storageAmount + (long)fluidStack.getAmount());
                fluidStack.setAmount(0);
                this.onFluidChanged(fluidId, false);
                return count;
            }
            this.storageFluids.replace(fluidId, Long.MAX_VALUE);
            fluidStack.setAmount(fluidStack.getAmount() - (int)remainingSpaces);
            this.onFluidChanged(fluidId, false);
            return (int)remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0;
        }
        this.storageFluids.put(fluidId, Long.valueOf(fluidStack.getAmount()));
        fluidStack.setAmount(0);
        this.onFluidChanged(fluidId, true);
        return count;
    }

    public long addItem(String itemId, long count) {
        if (itemId.equals("minecraft:air") || count == 0L) {
            return 0L;
        }
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if (remainingSpaces >= count) {
                this.storageItems.replace(itemId, storageCount + count);
                this.onItemChanged(itemId, false);
                return count;
            }
            this.storageItems.replace(itemId, Long.MAX_VALUE);
            this.onItemChanged(itemId, false);
            return remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0L;
        }
        this.storageItems.put(itemId, count);
        this.onItemChanged(itemId, true);
        return count;
    }

    public long addFluid(String fluidId, long count) {
        if (fluidId.equals("minecraft:air") || count == 0L) {
            return 0L;
        }
        if (this.storageFluids.containsKey(fluidId)) {
            long storageAmount = this.storageFluids.get(fluidId);
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= count) {
                this.storageFluids.replace(fluidId, storageAmount + count);
                this.onFluidChanged(fluidId, false);
                return count;
            }
            this.storageFluids.replace(fluidId, Long.MAX_VALUE);
            this.onFluidChanged(fluidId, false);
            return remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0L;
        }
        this.storageFluids.put(fluidId, count);
        this.onFluidChanged(fluidId, true);
        return count;
    }

    public int addEnergy(int count) {
        if (this.storageEnergies.containsKey("avaritia:forge_energy")) {
            long storageAmount = this.storageEnergies.get("avaritia:forge_energy");
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= (long)count) {
                this.storageEnergies.replace("avaritia:forge_energy", storageAmount + (long)count);
                this.onEnergyChanged("avaritia:forge_energy", false);
                return count;
            }
            this.storageEnergies.replace("avaritia:forge_energy", Long.MAX_VALUE);
            this.onEnergyChanged("avaritia:forge_energy", false);
            return (int)remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0;
        }
        this.storageEnergies.put("avaritia:forge_energy", Long.valueOf(count));
        this.onEnergyChanged("avaritia:forge_energy", true);
        return count;
    }

    public long addEnergy(long count) {
        if (this.storageEnergies.containsKey("avaritia:forge_energy")) {
            long storageAmount = this.storageEnergies.get("avaritia:forge_energy");
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= count) {
                this.storageEnergies.replace("avaritia:forge_energy", storageAmount + count);
                this.onEnergyChanged("avaritia:forge_energy", false);
                return count;
            }
            this.storageEnergies.replace("avaritia:forge_energy", Long.MAX_VALUE);
            this.onEnergyChanged("avaritia:forge_energy", false);
            return remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0L;
        }
        this.storageEnergies.put("avaritia:forge_energy", count);
        this.onEnergyChanged("avaritia:forge_energy", true);
        return count;
    }

    public long addEnergy(String energyId, long count) {
        if (this.storageEnergies.containsKey(energyId)) {
            long storageAmount = this.storageEnergies.get(energyId);
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= count) {
                this.storageEnergies.replace(energyId, storageAmount + count);
                this.onEnergyChanged(energyId, false);
                return count;
            }
            this.storageEnergies.replace(energyId, Long.MAX_VALUE);
            this.onEnergyChanged(energyId, false);
            return remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0L;
        }
        this.storageEnergies.put(energyId, count);
        this.onEnergyChanged(energyId, true);
        return count;
    }

    public void fillItemStack(ItemStack itemStack, int count) {
        if (itemStack.m_41619_() || count == 0 || itemStack.m_41782_()) {
            return;
        }
        String itemId = StorageUtils.getItemId(itemStack.m_41720_());
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if ((long)count >= storageCount) {
                this.storageItems.remove(itemId);
                itemStack.m_41764_(itemStack.m_41613_() + (int)storageCount);
                this.onItemChanged(itemId, true);
            } else if (remainingSpaces < (long)(-count)) {
                this.storageItems.replace(itemId, Long.MAX_VALUE);
                itemStack.m_41764_(itemStack.m_41613_() - (int)remainingSpaces);
                this.onItemChanged(itemId, false);
            } else {
                this.storageItems.replace(itemId, storageCount - (long)count);
                itemStack.m_41764_(itemStack.m_41613_() + count);
                this.onItemChanged(itemId, false);
            }
        } else if (count < 0) {
            if (this.getChannelSize() >= 2000) {
                return;
            }
            this.storageItems.put(itemId, Long.valueOf(-count));
            itemStack.m_41764_(itemStack.m_41613_() + count);
            this.onItemChanged(itemId, true);
        }
    }

    public void fillFluidStack(FluidStack fluidStack, int count) {
        if (fluidStack.isEmpty() || count == 0 || fluidStack.hasTag()) {
            return;
        }
        String fluidId = StorageUtils.getFluidId(fluidStack.getFluid());
        if (this.storageFluids.containsKey(fluidId)) {
            long storageCount = this.storageFluids.get(fluidId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if ((long)count >= storageCount) {
                this.storageFluids.remove(fluidId);
                fluidStack.setAmount(fluidStack.getAmount() + (int)storageCount);
                this.onFluidChanged(fluidId, true);
            } else if (remainingSpaces < (long)(-count)) {
                this.storageFluids.replace(fluidId, Long.MAX_VALUE);
                fluidStack.setAmount(fluidStack.getAmount() - (int)remainingSpaces);
                this.onFluidChanged(fluidId, false);
            } else {
                this.storageFluids.replace(fluidId, storageCount - (long)count);
                fluidStack.setAmount(fluidStack.getAmount() + count);
                this.onFluidChanged(fluidId, false);
            }
        } else if (count < 0) {
            if (this.getChannelSize() >= 2000) {
                return;
            }
            this.storageFluids.put(fluidId, Long.valueOf(-count));
            fluidStack.setAmount(fluidStack.getAmount() + count);
            this.onFluidChanged(fluidId, true);
        }
    }

    public ItemStack takeItem(String itemId, int count) {
        if (!this.storageItems.containsKey(itemId) || itemId.equals("minecraft:air") || count == 0) {
            return ItemStack.f_41583_;
        }
        long storageCount = this.storageItems.get(itemId);
        if ((long)count < storageCount) {
            this.storageItems.replace(itemId, storageCount - (long)count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            count = (int)storageCount;
            this.onItemChanged(itemId, true);
        }
        return new ItemStack((ItemLike)StorageUtils.getItem(itemId), count);
    }

    public FluidStack takeFluid(String fluidId, int count) {
        if (!this.storageFluids.containsKey(fluidId) || fluidId.equals("minecraft:air") || count == 0) {
            return FluidStack.EMPTY;
        }
        long storageAmount = this.storageFluids.get(fluidId);
        if ((long)count < storageAmount) {
            this.storageFluids.replace(fluidId, storageAmount - (long)count);
            this.onFluidChanged(fluidId, false);
        } else {
            this.storageFluids.remove(fluidId);
            count = (int)storageAmount;
            this.onFluidChanged(fluidId, true);
        }
        return new FluidStack(StorageUtils.getFluid(fluidId), count);
    }

    public ItemStack saveTakeItem(String itemId, int count) {
        long storageCount;
        if (!this.storageItems.containsKey(itemId) || itemId.equals("minecraft:air") || count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), 1);
        if ((long)(count = Integer.min(count, itemStack.m_41741_())) < (storageCount = this.storageItems.get(itemId).longValue())) {
            this.storageItems.replace(itemId, storageCount - (long)count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            count = (int)storageCount;
            this.onItemChanged(itemId, true);
        }
        itemStack.m_41764_(count);
        return itemStack;
    }

    public ItemStack saveTakeItem(String itemId, boolean half) {
        long storageCount;
        if (!this.storageItems.containsKey(itemId)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), 1);
        int count = half ? (itemStack.m_41741_() + 1) / 2 : itemStack.m_41741_();
        if ((long)count < (storageCount = this.storageItems.get(itemId).longValue())) {
            this.storageItems.replace(itemId, storageCount - (long)count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            count = (int)storageCount;
            this.onItemChanged(itemId, true);
        }
        itemStack.m_41764_(count);
        return itemStack;
    }

    public void removeItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        String itemId = StorageUtils.getItemId(itemStack.m_41720_());
        if (!this.storageItems.containsKey(itemId)) {
            return;
        }
        long storageCount = this.storageItems.get(itemId);
        if ((long)itemStack.m_41613_() < storageCount) {
            this.storageItems.replace(itemId, storageCount - (long)itemStack.m_41613_());
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            this.onItemChanged(itemId, true);
        }
    }

    public void removeItem(String itemId, long count) {
        if (!this.storageItems.containsKey(itemId)) {
            return;
        }
        long storageCount = this.storageItems.get(itemId);
        if (count < storageCount) {
            this.storageItems.replace(itemId, storageCount - count);
            this.onItemChanged(itemId, false);
        } else {
            this.storageItems.remove(itemId);
            this.onItemChanged(itemId, true);
        }
    }

    public void removeEnergy(Long amount) {
        if (!this.storageEnergies.containsKey("avaritia:forge_energy")) {
            return;
        }
        long storageCount = this.storageEnergies.get("avaritia:forge_energy");
        if (amount < storageCount) {
            this.storageEnergies.replace("avaritia:forge_energy", storageCount - amount);
            this.onEnergyChanged("avaritia:forge_energy", false);
        } else {
            this.storageEnergies.remove("avaritia:forge_energy");
            this.onEnergyChanged("avaritia:forge_energy", true);
        }
    }

    public void removeEnergy(String energyId, Long amount) {
        if (!this.storageEnergies.containsKey(energyId)) {
            return;
        }
        long storageCount = this.storageEnergies.get(energyId);
        if (amount < storageCount) {
            this.storageEnergies.replace(energyId, storageCount - amount);
            this.onEnergyChanged(energyId, false);
        } else {
            this.storageEnergies.remove(energyId);
            this.onEnergyChanged(energyId, true);
        }
    }

    public boolean isEmpty() {
        return this.storageItems.isEmpty() && this.storageFluids.isEmpty() && this.storageEnergies.isEmpty();
    }

    public abstract boolean isRemoved();

    public String getName() {
        return this.channelName;
    }

    public void setName(String channelName) {
        this.channelName = channelName.substring(0, Math.min(channelName.length(), 64));
    }

    public int getSlots() {
        return this.storageItems.size() + 54;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.itemKeys.length + 27 || slot < 27) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.slotItemTemp[slot - 27];
        itemStack.m_41764_((int)Math.min(Integer.MAX_VALUE, this.storageItems.get(this.itemKeys[slot - 27])));
        return itemStack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || stack.m_41782_()) {
            return stack;
        }
        String itemId = StorageUtils.getItemId(stack.m_41720_());
        ItemStack remainingStack = ItemStack.f_41583_;
        if (this.storageItems.containsKey(itemId)) {
            long storageCount = this.storageItems.get(itemId);
            long remainingSpaces = Long.MAX_VALUE - storageCount;
            if (remainingSpaces >= (long)stack.m_41613_()) {
                if (!simulate) {
                    this.storageItems.replace(itemId, storageCount + (long)stack.m_41613_());
                }
            } else {
                if (!simulate) {
                    this.storageItems.replace(itemId, Long.MAX_VALUE);
                }
                remainingStack = stack.m_41777_();
                remainingStack.m_41764_(stack.m_41613_() - (int)remainingSpaces);
            }
            if (!simulate) {
                this.onItemChanged(itemId, false);
            }
        } else {
            if (this.getChannelSize() >= 2000) {
                return stack;
            }
            if (!simulate) {
                this.storageItems.put(itemId, Long.valueOf(stack.m_41613_()));
                this.onItemChanged(itemId, true);
            }
        }
        return remainingStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        long storageCount;
        if (slot >= this.itemKeys.length + 27 || slot < 27) {
            return ItemStack.f_41583_;
        }
        String itemId = this.itemKeys[slot - 27];
        if (!this.storageItems.containsKey(itemId)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemId), 1);
        int count = Math.min(itemStack.m_41741_(), amount);
        if ((long)count < (storageCount = this.storageItems.get(itemId).longValue())) {
            if (!simulate) {
                this.storageItems.replace(itemId, storageCount - (long)count);
                this.onItemChanged(itemId, false);
            }
        } else {
            if (!simulate) {
                this.storageItems.remove(itemId);
                this.onItemChanged(itemId, true);
            }
            count = (int)storageCount;
        }
        itemStack.m_41764_(count);
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return !stack.m_41619_() && !stack.m_41782_();
    }

    public int getTanks() {
        return this.storageFluids.size() + 18;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank >= this.fluidKeys.length + 9 || tank < 9) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.slotFluidTemp[tank - 9];
        fluidStack.setAmount((int)Math.min(Integer.MAX_VALUE, this.storageFluids.get(this.fluidKeys[tank - 9])));
        return fluidStack;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return !stack.isEmpty() && !stack.hasTag();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.hasTag()) {
            return 0;
        }
        String fluidId = StorageUtils.getFluidId(resource.getFluid());
        if (this.storageFluids.containsKey(fluidId)) {
            long storageAmount = this.storageFluids.get(fluidId);
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= (long)resource.getAmount()) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.storageFluids.replace(fluidId, storageAmount + (long)resource.getAmount());
                    this.onFluidChanged(fluidId, false);
                }
                return resource.getAmount();
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.storageFluids.replace(fluidId, Long.MAX_VALUE);
                this.onFluidChanged(fluidId, false);
            }
            return (int)remainingSpaces;
        }
        if (this.getChannelSize() >= 2000) {
            return 0;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.storageFluids.put(fluidId, Long.valueOf(resource.getAmount()));
            this.onFluidChanged(fluidId, true);
        }
        return resource.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        String fluidId = StorageUtils.getFluidId(resource.getFluid());
        if (!this.storageFluids.containsKey(fluidId) || resource.getAmount() <= 0) {
            return FluidStack.EMPTY;
        }
        long storageAmount = this.storageFluids.get(fluidId);
        int count = resource.getAmount();
        if ((long)count < storageAmount) {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.storageFluids.replace(fluidId, storageAmount - (long)count);
                this.onFluidChanged(fluidId, false);
            }
        } else {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.storageFluids.remove(fluidId);
                this.onFluidChanged(fluidId, true);
            }
            count = (int)storageAmount;
        }
        return new FluidStack(resource, count);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.storageFluids.isEmpty() || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        String fluidId = this.fluidKeys[0];
        long storageAmount = this.storageFluids.get(fluidId);
        if ((long)maxDrain < storageAmount) {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.storageFluids.replace(fluidId, storageAmount - (long)maxDrain);
                this.onFluidChanged(fluidId, false);
            }
        } else {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.storageFluids.remove(fluidId);
                this.onFluidChanged(fluidId, true);
            }
            maxDrain = (int)storageAmount;
        }
        return new FluidStack(StorageUtils.getFluid(fluidId), maxDrain);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.storageEnergies.containsKey("avaritia:forge_energy")) {
            long storageAmount = this.storageEnergies.get("avaritia:forge_energy");
            long remainingSpaces = Long.MAX_VALUE - storageAmount;
            if (remainingSpaces >= (long)maxReceive) {
                if (!simulate) {
                    this.storageEnergies.replace("avaritia:forge_energy", storageAmount + (long)maxReceive);
                    this.onEnergyChanged("avaritia:forge_energy", false);
                }
                return maxReceive;
            }
            if (!simulate) {
                this.storageEnergies.replace("avaritia:forge_energy", Long.MAX_VALUE);
                this.onEnergyChanged("avaritia:forge_energy", false);
            }
            return (int)remainingSpaces;
        }
        if (!simulate) {
            this.storageEnergies.put("avaritia:forge_energy", Long.valueOf(maxReceive));
            this.onEnergyChanged("avaritia:forge_energy", true);
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.storageEnergies.containsKey("avaritia:forge_energy")) {
            return 0;
        }
        long storageCount = this.storageEnergies.get("avaritia:forge_energy");
        if ((long)maxExtract < storageCount) {
            if (!simulate) {
                this.storageEnergies.replace("avaritia:forge_energy", storageCount - (long)maxExtract);
                this.onEnergyChanged("avaritia:forge_energy", false);
            }
            return maxExtract;
        }
        if (!simulate) {
            this.storageEnergies.remove("avaritia:forge_energy");
            this.onEnergyChanged("avaritia:forge_energy", true);
        }
        return (int)storageCount;
    }

    public int getEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.storageEnergies.getOrDefault("avaritia:forge_energy", 0L));
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return this.storageEnergies.containsKey("avaritia:forge_energy");
    }

    public boolean canReceive() {
        return this.storageEnergies.getOrDefault("avaritia:forge_energy", 0L) < Long.MAX_VALUE;
    }
}

