/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.common.container.DummyChannelContainer;
import committee.nova.mods.avaritia.core.channel.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class ClientChannel
extends Channel {
    @Nullable
    public DummyChannelContainer container;

    public void addListener(DummyChannelContainer container) {
        this.container = container;
    }

    public void removeListener() {
        this.container = null;
        this.storageItems.clear();
        this.storageFluids.clear();
        this.storageEnergies.clear();
    }

    @Override
    public void onItemChanged(String itemId, boolean listChanged) {
        super.onItemChanged(itemId, listChanged);
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    @Override
    public void onFluidChanged(String fluidId, boolean listChanged) {
        super.onFluidChanged(fluidId, listChanged);
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    @Override
    public void onEnergyChanged(String energyId, boolean listChanged) {
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    public void update(CompoundTag tag) {
        if (this.container == null) {
            return;
        }
        CompoundTag items = tag.m_128469_("items");
        CompoundTag fluids = tag.m_128469_("fluids");
        CompoundTag energies = tag.m_128469_("energies");
        String name = tag.m_128461_("name");
        AtomicBoolean fullUpdate = new AtomicBoolean(false);
        AtomicBoolean needRefreshContainer = new AtomicBoolean(false);
        items.m_128431_().forEach(itemId -> {
            long count = items.m_128454_(itemId);
            if (count <= 0L) {
                if (this.storageItems.containsKey(itemId)) {
                    this.storageItems.remove(itemId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageItems.containsKey(itemId)) {
                if ((Long)this.storageItems.get(itemId) != count) {
                    this.storageItems.replace(itemId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageItems.put(itemId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        fluids.m_128431_().forEach(fluidId -> {
            long count = fluids.m_128454_(fluidId);
            if (count <= 0L) {
                if (this.storageFluids.containsKey(fluidId)) {
                    this.storageFluids.remove(fluidId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageFluids.containsKey(fluidId)) {
                if ((Long)this.storageFluids.get(fluidId) != count) {
                    this.storageFluids.replace(fluidId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageFluids.put(fluidId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        energies.m_128431_().forEach(energyId -> {
            long count = energies.m_128454_(energyId);
            if (count <= 0L) {
                if (this.storageEnergies.containsKey(energyId)) {
                    this.storageEnergies.remove(energyId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageEnergies.containsKey(energyId)) {
                if ((Long)this.storageEnergies.get(energyId) != count) {
                    this.storageEnergies.replace(energyId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageEnergies.put(energyId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        if (!name.isEmpty()) {
            this.setName(name);
        }
        if (needRefreshContainer.get()) {
            this.container.refreshContainer(fullUpdate.get());
        }
        if (fullUpdate.get()) {
            this.updateItemKeys();
            this.updateFluidKeys();
        }
    }

    public void fullUpdate(CompoundTag tag) {
        CompoundTag items = tag.m_128469_("items");
        CompoundTag fluids = tag.m_128469_("fluids");
        CompoundTag energies = tag.m_128469_("energies");
        String name = tag.m_128461_("name");
        this.storageItems.clear();
        this.storageFluids.clear();
        this.storageEnergies.clear();
        items.m_128431_().forEach(itemId -> this.storageItems.put(itemId, items.m_128454_(itemId)));
        fluids.m_128431_().forEach(fluidId -> this.storageFluids.put(fluidId, fluids.m_128454_(fluidId)));
        energies.m_128431_().forEach(energyId -> this.storageEnergies.put(energyId, energies.m_128454_(energyId)));
        this.updateItemKeys();
        this.updateFluidKeys();
        this.setName(name);
        if (this.container != null) {
            this.container.refreshContainer(true);
        }
    }

    @Override
    public boolean isRemoved() {
        return false;
    }
}

