/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.common.block.compressor.NeutronCompressorBlock;
import committee.nova.mods.avaritia.common.block.craft.TierCraftTableBlock;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeSmithingTableBlock;
import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import committee.nova.mods.avaritia.common.tile.TierCraftTile;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)CompressorComponentProvider.INSTANCE, NeutronCompressorBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)CraftingComponentProvider.INSTANCE, TierCraftTableBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)ExtremeSmithingComponentProvider.INSTANCE, ExtremeSmithingTableBlock.class);
    }

    public static final class CompressorComponentProvider
    extends Enum<CompressorComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ CompressorComponentProvider INSTANCE = new CompressorComponentProvider();
        private static final /* synthetic */ CompressorComponentProvider[] $VALUES;

        public static CompressorComponentProvider[] values() {
            return (CompressorComponentProvider[])$VALUES.clone();
        }

        public static CompressorComponentProvider valueOf(String name) {
            return Enum.valueOf(CompressorComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            NeutronCompressorTile compressor = (NeutronCompressorTile)accessor.getBlockEntity();
            ICompressorRecipe recipe = compressor.getActiveRecipe();
            if (recipe != null) {
                ItemStack output = recipe.m_8043_(level.m_9598_());
                tooltip.add((Component)ModTooltips.COMPRESS.args(output.m_41613_(), output.m_41786_()).build());
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("avaritia", "compressor");
        }

        private static /* synthetic */ CompressorComponentProvider[] $values() {
            return new CompressorComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = CompressorComponentProvider.$values();
        }
    }

    public static final class CraftingComponentProvider
    extends Enum<CraftingComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ CraftingComponentProvider INSTANCE = new CraftingComponentProvider();
        private static final /* synthetic */ CraftingComponentProvider[] $VALUES;

        public static CraftingComponentProvider[] values() {
            return (CraftingComponentProvider[])$VALUES.clone();
        }

        public static CraftingComponentProvider valueOf(String name) {
            return Enum.valueOf(CraftingComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            TierCraftTile craftTile = (TierCraftTile)accessor.getBlockEntity();
            Optional recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), craftTile.getInventory().toIInventory(), (Level)level);
            if (recipe.isPresent()) {
                ItemStack output = ((ITierCraftingRecipe)recipe.get()).m_8043_(level.m_9598_());
                tooltip.add((Component)ModTooltips.CRAFTING.args(I18n.m_118938_((String)("jei.category.avaritia." + craftTile.tier.name), (Object[])new Object[0]), output.m_41613_(), output.m_41786_()).build());
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("avaritia", "crafting_table");
        }

        private static /* synthetic */ CraftingComponentProvider[] $values() {
            return new CraftingComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = CraftingComponentProvider.$values();
        }
    }

    public static final class ExtremeSmithingComponentProvider
    extends Enum<ExtremeSmithingComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ ExtremeSmithingComponentProvider INSTANCE = new ExtremeSmithingComponentProvider();
        private static final /* synthetic */ ExtremeSmithingComponentProvider[] $VALUES;

        public static ExtremeSmithingComponentProvider[] values() {
            return (ExtremeSmithingComponentProvider[])$VALUES.clone();
        }

        public static ExtremeSmithingComponentProvider valueOf(String name) {
            return Enum.valueOf(ExtremeSmithingComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            List recipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get());
            if (!recipes.isEmpty()) {
                ExtremeSmithingRecipe recipe = (ExtremeSmithingRecipe)recipes.get(0);
                ItemStack output = recipe.m_8043_(level.m_9598_());
                tooltip.add((Component)ModTooltips.SMITHING.args(output.m_41613_(), output.m_41786_()).build());
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("avaritia", "extreme_smithing");
        }

        private static /* synthetic */ ExtremeSmithingComponentProvider[] $values() {
            return new ExtremeSmithingComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = ExtremeSmithingComponentProvider.$values();
        }
    }
}

