/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data;

import committee.nova.mods.avaritia.init.data.ModRegistries;
import committee.nova.mods.avaritia.init.data.provider.ModAdvancements;
import committee.nova.mods.avaritia.init.data.provider.ModBlockStates;
import committee.nova.mods.avaritia.init.data.provider.ModBlockTags;
import committee.nova.mods.avaritia.init.data.provider.ModDamageTypeTags;
import committee.nova.mods.avaritia.init.data.provider.ModEntityTags;
import committee.nova.mods.avaritia.init.data.provider.ModItemTags;
import committee.nova.mods.avaritia.init.data.provider.ModRecipes;
import committee.nova.mods.avaritia.init.data.provider.ModSoundDefinitions;
import committee.nova.mods.avaritia.init.data.provider.ModSpriteSource;
import committee.nova.mods.avaritia.init.data.provider.loot.ModLootTables;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture future = event.getLookupProvider();
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ModBlockStates(output, helper));
            generator.addProvider(true, (DataProvider)new ModSpriteSource(output, helper));
            generator.addProvider(true, (DataProvider)new ModSoundDefinitions(output, helper));
        }
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new ModRecipes(output));
            generator.addProvider(true, (DataProvider)new ModLootTables(output));
            generator.addProvider(true, (DataProvider)new ModItemTags(output, future, helper));
            generator.addProvider(true, (DataProvider)new ModBlockTags(output, future, helper));
            generator.addProvider(true, (DataProvider)new ModEntityTags(output, future, helper));
            generator.addProvider(true, (DataProvider)new ModAdvancements(output, future, helper));
            generator.addProvider(true, (DataProvider)new ModRegistries(generator.getPackOutput(), future));
            generator.addProvider(true, (DataProvider)new ModDamageTypeTags(generator.getPackOutput(), (CompletableFuture<HolderLookup.Provider>)future.thenApply(ModDamageTypes::append), helper));
            generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Avaritia Resources"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
        }
    }
}

