/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ModShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ItemLike result;
    private final ResourceLocation result2;
    private final int count;
    private final int tier;
    private final CompoundTag nbt;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private boolean showNotification = true;

    public ModShapedRecipeBuilder(RecipeCategory category, ItemLike itemLike, ResourceLocation itemLocation, int count, int tier, CompoundTag nbt) {
        this.category = category;
        this.result = itemLike;
        this.result2 = itemLocation;
        this.count = count;
        this.nbt = nbt;
        this.tier = tier;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ResourceLocation itemLocation, CompoundTag nbt, int tier) {
        return ModShapedRecipeBuilder.shaped(category, null, itemLocation, 1, tier, nbt);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ResourceLocation itemLocation, CompoundTag nbt) {
        return ModShapedRecipeBuilder.shaped(category, null, itemLocation, 1, 4, nbt);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ResourceLocation itemLocation, int tier) {
        return ModShapedRecipeBuilder.shaped(category, null, itemLocation, 1, tier, new CompoundTag());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ResourceLocation itemLocation) {
        return ModShapedRecipeBuilder.shaped(category, null, itemLocation, 1, 4, new CompoundTag());
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike, CompoundTag nbt, int tier) {
        return ModShapedRecipeBuilder.shaped(category, itemLike, null, 1, tier, nbt);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike, CompoundTag nbt) {
        return ModShapedRecipeBuilder.shaped(category, itemLike, null, 1, 4, nbt);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike, int tier) {
        return ModShapedRecipeBuilder.shaped(category, itemLike, null, 1, tier, new CompoundTag());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike) {
        return ModShapedRecipeBuilder.shaped(category, itemLike, null, 1, 4, new CompoundTag());
    }

    @Contract(value="_, _, _, _, _, _ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike, ResourceLocation itemLocation, int count, int tier, CompoundTag nbt) {
        return new ModShapedRecipeBuilder(category, itemLike, itemLocation, count, tier, nbt);
    }

    @Contract(value="_,_,_,_ -> new")
    @NotNull
    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike itemLike, int count, int tier) {
        return ModShapedRecipeBuilder.shaped(category, itemLike, null, count, tier, new CompoundTag());
    }

    public ModShapedRecipeBuilder define(Character character, TagKey<Item> tagKey) {
        return this.define(character, Ingredient.m_204132_(tagKey));
    }

    public ModShapedRecipeBuilder define(Character character, ItemLike itemLike) {
        return this.define(character, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public ModShapedRecipeBuilder define(Character character, ItemStack stack) {
        return this.define(character, (Ingredient)StrictNBTIngredient.of((ItemStack)stack));
    }

    public ModShapedRecipeBuilder define(Character character, Ingredient ingredient) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        return this;
    }

    public ModShapedRecipeBuilder pattern(String s) {
        if (!this.rows.isEmpty() && s.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(s);
        return this;
    }

    @NotNull
    public ModShapedRecipeBuilder unlockedBy(@NotNull String string, @NotNull CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(string, pCriterionTrigger);
        return this;
    }

    @NotNull
    public ModShapedRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ModShapedRecipeBuilder showNotification(boolean show) {
        this.showNotification = show;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        if (this.result != null) {
            return this.result.m_5456_();
        }
        if (this.result2 != null) {
            return Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(this.result2));
        }
        return Items.f_41852_;
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> recipeConsumer, @NotNull ResourceLocation location) {
        this.ensureValid(location);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)location)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)location)).m_138360_(RequirementsStrategy.f_15979_);
        recipeConsumer.accept((FinishedRecipe)new Result(location, this.result, this.result2, this.count, this.tier, this.nbt, this.group == null ? "" : this.group, ModShapedRecipeBuilder.m_245179_((RecipeCategory)this.category), this.rows, this.key, this.advancement, location.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification));
    }

    private void ensureValid(ResourceLocation resourceLocation) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + resourceLocation + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + resourceLocation + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + resourceLocation);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + resourceLocation + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final ItemLike result;
        private final ResourceLocation result2;
        private final int count;
        private final int tier;
        private final CompoundTag nbt;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean showNotification;

        public Result(ResourceLocation resourceLocation, ItemLike item, ResourceLocation result2, int count, int tier, CompoundTag nbt, String group, CraftingBookCategory p_273500_, List<String> p_273744_, Map<Character, Ingredient> p_272991_, Advancement.Builder p_273260_, ResourceLocation p_273106_, boolean p_272862_) {
            super(p_273500_);
            this.id = resourceLocation;
            this.result = item;
            this.result2 = result2;
            this.count = count;
            this.tier = tier;
            this.nbt = nbt;
            this.group = group;
            this.pattern = p_273744_;
            this.key = p_272991_;
            this.advancement = p_273260_;
            this.advancementId = p_273106_;
            this.showNotification = p_272862_;
        }

        public void m_7917_(@NotNull JsonObject pJson) {
            super.m_7917_(pJson);
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.addProperty("tier", (Number)this.tier);
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            pJson.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            pJson.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            if (this.result != null) {
                jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_5456_())).toString());
            }
            if (this.result2 != null) {
                jsonObject.addProperty("item", this.result2.toString());
            }
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            if (!this.nbt.m_128456_()) {
                jsonObject.addProperty("nbt", this.nbt.toString());
            }
            pJson.add("result", (JsonElement)jsonObject);
            pJson.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.SHAPED_CRAFT_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

