package committee.nova.mods.avaritia.client.screen.craft;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.TierCraftMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

/**
 * Description:
 * @author cnlimiter
 * Date: 2022/4/2 11:40
 * Version: 1.0
 */
public class ExtremeCraftScreen extends BaseContainerScreen<TierCraftMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation(Const.MOD_ID, "textures/gui/craft/extreme_crafting_table_gui.png");

    public ExtremeCraftScreen(TierCraftMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, BACKGROUND, 234, 278, 512, 512);
    }

    @Override
    protected void renderLabels(GuiGraphics stack, int mouseX, int mouseY) {
        var title = this.getTitle().getString();

        stack.drawString(font, title, 8, 6, 4210752, false);
        stack.drawString(font, this.playerInventoryTitle, 39, this.imageHeight - 94, 4210752, false);
    }
}
