/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class FluidItemRender {
    private final ResourceLocation texture;
    private final int referenceWidth;
    private final int referenceHeight;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 255;
    private Rect2i srcRect;
    private Rect2i destRect = new Rect2i(0, 0, 0, 0);
    private boolean blending = true;

    public FluidItemRender(ResourceLocation texture, int referenceWidth, int referenceHeight) {
        this.texture = texture;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
    }

    public static FluidItemRender sprite(TextureAtlasSprite sprite) {
        int refSize = 0x3FFFFFFF;
        return new FluidItemRender(sprite.m_247685_(), 0x3FFFFFFF, 0x3FFFFFFF).src((int)(sprite.m_118409_() * 1.0737418E9f), (int)(sprite.m_118411_() * 1.0737418E9f), (int)((sprite.m_118410_() - sprite.m_118409_()) * 1.0737418E9f), (int)((sprite.m_118412_() - sprite.m_118411_()) * 1.0737418E9f));
    }

    public FluidItemRender src(int x, int y, int w, int h) {
        this.srcRect = new Rect2i(x, y, w, h);
        return this;
    }

    public FluidItemRender dest(int x, int y, int w, int h) {
        this.destRect = new Rect2i(x, y, w, h);
        return this;
    }

    public FluidItemRender color(float r, float g, float b) {
        this.r = (int)(Mth.m_14036_((float)r, (float)0.0f, (float)1.0f) * 255.0f);
        this.g = (int)(Mth.m_14036_((float)g, (float)0.0f, (float)1.0f) * 255.0f);
        this.b = (int)(Mth.m_14036_((float)b, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public FluidItemRender opacity(float a) {
        this.a = (int)(Mth.m_14036_((float)a, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public FluidItemRender blending(boolean enable) {
        this.blending = enable;
        return this;
    }

    public FluidItemRender colorRgb(int packedRgb) {
        float r = (float)(packedRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedRgb & 0xFF) / 255.0f;
        return this.color(r, g, b);
    }

    public void blit(PoseStack poseStack, int zIndex) {
        float maxU;
        float maxV;
        float minU;
        float minV;
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        if (this.srcRect == null) {
            minV = 0.0f;
            minU = 0.0f;
            maxV = 1.0f;
            maxU = 1.0f;
        } else {
            minU = (float)this.srcRect.m_110085_() / (float)this.referenceWidth;
            minV = (float)this.srcRect.m_110086_() / (float)this.referenceHeight;
            maxU = (float)(this.srcRect.m_110085_() + this.srcRect.m_110090_()) / (float)this.referenceWidth;
            maxV = (float)(this.srcRect.m_110086_() + this.srcRect.m_110091_()) / (float)this.referenceHeight;
        }
        float x1 = this.destRect.m_110085_();
        float y1 = this.destRect.m_110086_();
        float x2 = x1;
        float y2 = y1;
        if (this.destRect.m_110090_() != 0 && this.destRect.m_110091_() != 0) {
            x2 += (float)this.destRect.m_110090_();
            y2 += (float)this.destRect.m_110091_();
        } else if (this.srcRect != null) {
            x2 += (float)this.srcRect.m_110090_();
            y2 += (float)this.srcRect.m_110091_();
        }
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix, x1, y2, (float)zIndex).m_7421_(minU, maxV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_252986_(matrix, x2, y2, (float)zIndex).m_7421_(maxU, maxV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_252986_(matrix, x2, y1, (float)zIndex).m_7421_(maxU, minV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_252986_(matrix, x1, y1, (float)zIndex).m_7421_(minU, minV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        if (this.blending) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
        } else {
            RenderSystem.disableBlend();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void renderFluid(FluidStack fluidStack, PoseStack poseStack, int x, int y, int z) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(attributes.getStillTexture(fluidStack));
        FluidItemRender.sprite(sprite).colorRgb(attributes.getTintColor(fluidStack)).blending(false).dest(x, y, 16, 16).blit(poseStack, z);
    }
}

