/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render.pipeline.attribute;

import committee.nova.mods.avaritia.api.client.render.CCRenderState;
import committee.nova.mods.avaritia.api.client.render.pipeline.VertexAttribute;
import committee.nova.mods.avaritia.api.client.render.pipeline.attribute.AttributeKey;
import committee.nova.mods.avaritia.api.client.util.color.ColorRGBA;

public class LightingAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = AttributeKey.create("lighting", int[]::new);
    private int[] colourRef;

    public LightingAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        if (!(ccrs.computeLighting && ccrs.cFmt.hasColor && ccrs.model.hasAttribute(attributeKey))) {
            return false;
        }
        this.colourRef = ccrs.model.getAttribute(attributeKey);
        if (this.colourRef != null) {
            ccrs.pipeline.addDependency(ccrs.colourAttrib);
            return true;
        }
        return false;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.colour = ColorRGBA.multiply(ccrs.colour, this.colourRef[ccrs.vertexIndex]);
    }
}

