/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen.component;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CycleTextureButton<T>
extends AbstractButton {
    public static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::m_96639_;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final Component name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, Component> valueStringifier;
    private final Function<CycleTextureButton<T>, MutableComponent> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final boolean displayOnlyValue;
    private final OptionInstance.TooltipSupplier<T> tooltipSupplier;
    protected final ResourceLocation resourceLocation;
    protected final int xTexStart;
    protected final int yTexStart;
    protected final int xDiffTex;
    protected final int yDiffTex;
    protected final int textureWidth;
    protected final int textureHeight;
    private final int xOffset;
    private final int yOffset;
    private final int usedTextureWidth;
    private final int usedTextureHeight;

    CycleTextureButton(Component message, Component name, int index, T value, ValueListSupplier<T> values, Function<T, Component> valueStringifier, Function<CycleTextureButton<T>, MutableComponent> narrationProvider, OnValueChange<T> onValueChange, OptionInstance.TooltipSupplier<T> tooltipSupplier, boolean displayOnlyValue, ResourceLocation resourceLocation, int x, int y, int width, int height, int xTexStart, int yTexStart, int xOffset, int yOffset, int textureWidth, int textureHeight, int xDiffTex, int yDiffTex) {
        super(x, y, width, height, message);
        this.name = name;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueStringifier = valueStringifier;
        this.narrationProvider = narrationProvider;
        this.onValueChange = onValueChange;
        this.displayOnlyValue = displayOnlyValue;
        this.tooltipSupplier = tooltipSupplier;
        this.m_257936_();
        this.resourceLocation = resourceLocation;
        this.usedTextureWidth = width;
        this.usedTextureHeight = height;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.xDiffTex = xDiffTex;
        this.yDiffTex = yDiffTex;
    }

    private void m_257936_() {
        this.m_257544_(this.tooltipSupplier.m_257630_(this.value));
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int delta) {
        List<T> list = this.values.getSelectedList();
        this.index = Mth.m_14100_((int)(this.index + delta), (int)list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int delta) {
        List<T> list = this.values.getSelectedList();
        return list.get(Mth.m_14100_((int)(this.index + delta), (int)list.size()));
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableDepthTest();
        if (this.m_198029_()) {
            guiGraphics.m_280163_(this.resourceLocation, this.getXOffset(), this.getYOffset(), (float)this.xTexStart + (float)(this.xDiffTex * this.index), (float)(this.yTexStart + this.yDiffTex), this.usedTextureWidth, this.usedTextureHeight, this.textureWidth, this.textureHeight);
        } else {
            guiGraphics.m_280163_(this.resourceLocation, this.getXOffset(), this.getYOffset(), (float)this.xTexStart + (float)(this.xDiffTex * this.index), (float)this.yTexStart, this.usedTextureWidth, this.usedTextureHeight, this.textureWidth, this.textureHeight);
        }
    }

    private int getXOffset() {
        return this.m_252754_() + (this.f_93618_ / 2 - this.usedTextureWidth / 2) + this.xOffset;
    }

    private int getYOffset() {
        return this.m_252907_() + (this.f_93619_ / 2 - this.usedTextureHeight / 2) + this.yOffset;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.cycleValue(-1);
        } else if (delta < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T value) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(value);
    }

    private void updateValue(T value) {
        Component component = this.createLabelForValue(value);
        this.m_93666_(component);
        this.value = value;
        this.m_257936_();
    }

    private Component createLabelForValue(T value) {
        return this.displayOnlyValue ? this.valueStringifier.apply(value) : this.createFullName(value);
    }

    private MutableComponent createFullName(T value) {
        return CommonComponents.m_178393_((Component)this.name, (Component)this.valueStringifier.apply(value));
    }

    public T getValue() {
        return this.value;
    }

    @NotNull
    protected MutableComponent m_5646_() {
        return this.narrationProvider.apply(this);
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            T t = this.getCycledValue(1);
            Component component = this.createLabelForValue(t);
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public MutableComponent createDefaultNarrationMessage() {
        return CycleTextureButton.m_168799_((Component)(this.displayOnlyValue ? this.createFullName(this.value) : this.m_6035_()));
    }

    public static <T> Builder<T> builder(Function<T, Component> valueStringifier) {
        return new Builder<T>(valueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(Component componentOn, Component componentOff) {
        return new Builder<Object>(o -> (Boolean)o != false ? componentOn : componentOff).withValues((Collection<Object>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Object>(o -> (Boolean)o != false ? CommonComponents.f_130653_ : CommonComponents.f_130654_).withValues((Collection<Object>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean initialValue) {
        return CycleTextureButton.onOffBuilder().withInitialValue(initialValue);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier altListSelector, List<T> defaultList, List<T> selectedList) {
            ImmutableList list = ImmutableList.copyOf(defaultList);
            ImmutableList list1 = ImmutableList.copyOf(selectedList);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list1;
                final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return altListSelector.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnValueChange<T> {
        public void onValueChange(CycleTextureButton<T> var1, T var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, Component> valueStringifier;
        private OptionInstance.TooltipSupplier<T> tooltipSupplier = p_168964_ -> null;
        private Function<CycleTextureButton<T>, MutableComponent> narrationProvider = CycleTextureButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;
        private int x = 0;
        private int y = 0;
        private int width = 20;
        private int height = 20;
        private int xTexStart;
        private int yTexStart;
        private int xDiffTex;
        private int yDiffTex;
        private int textureWidth;
        private int textureHeight;
        private int xOffset;
        private int yOffset;

        public Builder(Function<T, Component> valueStringifier) {
            this.valueStringifier = valueStringifier;
        }

        public Builder<T> withValues(Collection<T> values) {
            return this.withValues(ValueListSupplier.create(values));
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... values) {
            return this.withValues((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> withValues(List<T> defaultList, List<T> selectedList) {
            return this.withValues(ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, defaultList, selectedList));
        }

        public Builder<T> withValues(BooleanSupplier altListSelector, List<T> defaultList, List<T> selectedList) {
            return this.withValues(ValueListSupplier.create(altListSelector, defaultList, selectedList));
        }

        public Builder<T> withValues(ValueListSupplier<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> withTooltip(OptionInstance.TooltipSupplier<T> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public Builder<T> withInitialValue(T initialValue) {
            this.initialValue = initialValue;
            int i = this.values.getDefaultList().indexOf(initialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<CycleTextureButton<T>, MutableComponent> narrationProvider) {
            this.narrationProvider = narrationProvider;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public Builder<T> bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<T> texStart(int x, int y) {
            this.xTexStart = x;
            this.yTexStart = y;
            return this;
        }

        public Builder<T> offset(int x, int y) {
            this.xOffset = x;
            this.yOffset = y;
            return this;
        }

        public Builder<T> xDiffTex(int xDiffTex) {
            this.xDiffTex = xDiffTex;
            return this;
        }

        public Builder<T> yDiffTex(int yDiffTex) {
            this.yDiffTex = yDiffTex;
            return this;
        }

        public Builder<T> textureSize(int width, int height) {
            this.textureWidth = width;
            this.textureHeight = height;
            return this;
        }

        public CycleTextureButton<T> create(ResourceLocation resourceLocation, Component name) {
            return this.create(resourceLocation, name, (p_168946_, p_168947_) -> {});
        }

        public CycleTextureButton<T> create(ResourceLocation resourceLocation, Component name, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            Component component = this.valueStringifier.apply(t);
            Component component1 = this.displayOnlyValue ? component : CommonComponents.m_178393_((Component)name, (Component)component);
            return new CycleTextureButton<T>(component1, name, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, onValueChange, this.tooltipSupplier, this.displayOnlyValue, resourceLocation, this.x, this.y, this.width, this.height, this.xTexStart, this.yTexStart, this.xOffset, this.yOffset, this.textureWidth, this.textureHeight, this.xDiffTex, this.yDiffTex);
        }
    }
}

