/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen.component;

import committee.nova.mods.avaritia.api.client.util.key.GLFWKeyHelper;
import committee.nova.mods.avaritia.api.util.StringUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class KeyEventManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Integer> pressedKeys = new LinkedHashSet<Integer>();
    @Deprecated
    private int modifiers = -1;
    private final Set<Integer> pressedMouses = new LinkedHashSet<Integer>();
    private double mousedScroll;
    private double mouseDownX;
    private double mouseDownY;
    private double mouseX;
    private double mouseY;
    private boolean active = false;

    @Deprecated
    public void keyPressed(int keyCode, int modifiers) {
        this.pressedKeys.add(keyCode);
        this.modifiers = modifiers;
    }

    @Deprecated
    public void keyReleased(int keyCode, int modifiers) {
        this.pressedKeys.remove(keyCode);
        this.modifiers = -1;
    }

    public void keyPressed(int keyCode) {
        this.pressedKeys.add(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.pressedKeys.remove(keyCode);
    }

    public void mouseClicked(int mouseButton, double mouseX, double mouseY) {
        this.pressedMouses.add(mouseButton);
        this.mouseDownX = mouseX;
        this.mouseDownY = mouseY;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void mouseReleased(int mouseButton, double mouseX, double mouseY) {
        this.pressedMouses.remove(mouseButton);
        this.mouseDownX = -1.0;
        this.mouseDownY = -1.0;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void mouseScrolled(double mousedScroll, double mouseX, double mouseY) {
        this.mousedScroll = mousedScroll;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void refresh(double mouseX, double mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (!Minecraft.m_91087_().m_91302_()) {
            if (this.active) {
                LOGGER.debug("Window is not active, clear all pressed keys and mouses");
            }
            this.active = false;
            this.pressedKeys.clear();
            this.pressedMouses.clear();
            this.mouseDownX = -1.0;
            this.mouseDownY = -1.0;
            this.mousedScroll = 0.0;
            this.modifiers = -1;
        } else {
            this.active = true;
        }
    }

    public boolean isKeyPressed(int keyCode) {
        return this.pressedKeys.contains(keyCode);
    }

    public boolean isCtrlPressed() {
        return this.isKeyPressed(341) || this.isKeyPressed(345);
    }

    public boolean isShiftPressed() {
        return this.isKeyPressed(340) || this.isKeyPressed(344);
    }

    public boolean isAltPressed() {
        return this.isKeyPressed(342) || this.isKeyPressed(346);
    }

    public boolean isSuperPressed() {
        return this.isKeyPressed(343) || this.isKeyPressed(347);
    }

    public boolean onlyCtrlPressed() {
        return this.pressedKeys.size() == 1 && this.isCtrlPressed();
    }

    public boolean onlyShiftPressed() {
        return this.pressedKeys.size() == 1 && this.isShiftPressed();
    }

    public boolean onlyAltPressed() {
        return this.pressedKeys.size() == 1 && this.isAltPressed();
    }

    public boolean onlySuperPressed() {
        return this.pressedKeys.size() == 1 && this.isSuperPressed();
    }

    public boolean onlyCtrlShiftPressed() {
        return this.pressedKeys.size() == 2 && this.isCtrlPressed() && this.isShiftPressed();
    }

    public boolean onlyCtrlAltPressed() {
        return this.pressedKeys.size() == 2 && this.isCtrlPressed() && this.isAltPressed();
    }

    public boolean onlyCtrlSuperPressed() {
        return this.pressedKeys.size() == 2 && this.isCtrlPressed() && this.isSuperPressed();
    }

    public boolean onlyShiftAltPressed() {
        return this.pressedKeys.size() == 2 && this.isShiftPressed() && this.isAltPressed();
    }

    public boolean onlyShiftSuperPressed() {
        return this.pressedKeys.size() == 2 && this.isShiftPressed() && this.isSuperPressed();
    }

    public boolean onlyAltSuperPressed() {
        return this.pressedKeys.size() == 2 && this.isAltPressed() && this.isSuperPressed();
    }

    public boolean onlyCtrlShiftAltPressed() {
        return this.pressedKeys.size() == 3 && this.isCtrlPressed() && this.isShiftPressed() && this.isAltPressed();
    }

    public boolean ieEscapePressed() {
        return this.isKeyPressed(256);
    }

    public boolean ieEnterPressed() {
        return this.isKeyPressed(257) || this.isKeyPressed(335);
    }

    public boolean ieBackspacePressed() {
        return this.isKeyPressed(259);
    }

    public boolean ieDeletePressed() {
        return this.isKeyPressed(261);
    }

    public boolean onlyEscapePressed() {
        return this.pressedKeys.size() == 1 && this.ieEscapePressed();
    }

    public boolean onlyEnterPressed() {
        return this.pressedKeys.size() == 1 && this.ieEnterPressed();
    }

    public boolean onlyBackspacePressed() {
        return this.pressedKeys.size() == 1 && this.ieBackspacePressed();
    }

    public boolean onlyDeletePressed() {
        return this.pressedKeys.size() == 1 && this.ieDeletePressed();
    }

    public boolean isMousePressed(int mouseButton) {
        return this.pressedMouses.contains(mouseButton);
    }

    public boolean isMouseLeftPressed() {
        return this.isMousePressed(0);
    }

    public boolean isMouseRightPressed() {
        return this.isMousePressed(1);
    }

    public boolean isMouseMiddlePressed() {
        return this.isMousePressed(2);
    }

    public boolean onlyMouseLeftPressed() {
        return this.pressedMouses.size() == 1 && this.isMouseLeftPressed();
    }

    public boolean onlyMouseRightPressed() {
        return this.pressedMouses.size() == 1 && this.isMouseRightPressed();
    }

    public boolean onlyMouseMiddlePressed() {
        return this.pressedMouses.size() == 1 && this.isMouseMiddlePressed();
    }

    public boolean onlyMouseLeftRightPressed() {
        return this.pressedMouses.size() == 2 && this.isMouseLeftPressed() && this.isMouseRightPressed();
    }

    public boolean isMouseDragged() {
        return this.mouseDownX != -1.0 && this.mouseDownY != -1.0;
    }

    public boolean isMouseDragged(int mouseButton) {
        return this.isMouseDragged() && this.pressedMouses.contains(mouseButton);
    }

    public boolean isMouseMoved() {
        return Math.abs(this.mouseX - this.mouseDownX) > 1.0 || Math.abs(this.mouseY - this.mouseDownY) > 1.0;
    }

    public boolean isKeyPressed(String keyNames) {
        if (StringUtils.isNullOrEmptyEx(keyNames)) {
            return false;
        }
        return GLFWKeyHelper.matchKey(keyNames, this.pressedKeys.stream().mapToInt(i -> i).toArray());
    }

    public boolean isKeyPressedInOrder(String keyNames) {
        if (StringUtils.isNullOrEmptyEx(keyNames)) {
            return false;
        }
        return GLFWKeyHelper.matchKeyInOrder(keyNames, this.pressedKeys.stream().mapToInt(i -> i).toArray());
    }

    public boolean isMousePressed(String mouseNames) {
        if (StringUtils.isNullOrEmptyEx(mouseNames)) {
            return false;
        }
        return GLFWKeyHelper.matchMouse(mouseNames, this.pressedMouses.stream().mapToInt(i -> i).toArray());
    }

    public boolean isMousePressedInOrder(String mouseNames) {
        if (StringUtils.isNullOrEmptyEx(mouseNames)) {
            return false;
        }
        return GLFWKeyHelper.matchMouseInOrder(mouseNames, this.pressedMouses.stream().mapToInt(i -> i).toArray());
    }

    public boolean isKeyAndMousePressed(String names) {
        String[] parts;
        if (StringUtils.isNullOrEmptyEx(names)) {
            return false;
        }
        StringBuilder keyNames = new StringBuilder();
        StringBuilder mouseNames = new StringBuilder();
        for (String part : parts = names.split("\\+")) {
            if (part.startsWith("Mouse")) {
                mouseNames.append(part).append("+");
                continue;
            }
            keyNames.append(part).append("+");
        }
        return !(!StringUtils.isNullOrEmptyEx(keyNames.toString()) && !this.isKeyPressed(keyNames.toString()) || !StringUtils.isNullOrEmptyEx(mouseNames.toString()) && !this.isMousePressed(mouseNames.toString()));
    }

    @Generated
    public double getMousedScroll() {
        return this.mousedScroll;
    }

    @Generated
    public double getMouseDownX() {
        return this.mouseDownX;
    }

    @Generated
    public double getMouseDownY() {
        return this.mouseDownY;
    }

    @Generated
    public double getMouseX() {
        return this.mouseX;
    }

    @Generated
    public double getMouseY() {
        return this.mouseY;
    }
}

