/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util.color;

import committee.nova.mods.avaritia.api.util.java.Copyable;
import committee.nova.mods.avaritia.api.util.math.MathUtils;

public abstract class Color
implements Copyable<Color> {
    public byte r;
    public byte g;
    public byte b;
    public byte a;

    public Color(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
    }

    public Color(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
    }

    public static int flipABGR(int colour) {
        int a = colour >> 24 & 0xFF;
        int b = colour >> 16 & 0xFF;
        int c = colour >> 8 & 0xFF;
        int d = colour & 0xFF;
        return (d & 0xFF) << 24 | (c & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int[] unpack(int colour) {
        return new int[]{colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF};
    }

    public static int pack(int[] data) {
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public static int packRGBA(byte r, byte g, byte b, byte a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int packARGB(byte r, byte g, byte b, byte a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int packRGBA(int r, int g, int b, int a) {
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static int packARGB(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int packRGBA(double r, double g, double b, double a) {
        return (int)(r * 255.0) << 24 | (int)(g * 255.0) << 16 | (int)(b * 255.0) << 8 | (int)(a * 255.0);
    }

    public static int packARGB(double r, double g, double b, double a) {
        return (int)(a * 255.0) << 24 | (int)(r * 255.0) << 16 | (int)(g * 255.0) << 8 | (int)(b * 255.0);
    }

    public static int packRGBA(float[] data) {
        return Color.packRGBA(data[0], data[1], data[2], data[3]);
    }

    public static int packARGB(float[] data) {
        return Color.packARGB(data[0], data[1], data[2], data[3]);
    }

    public abstract int pack();

    public abstract float[] packArray();

    public Color add(Color color2) {
        this.a = (byte)(this.a + color2.a);
        this.r = (byte)(this.r + color2.r);
        this.g = (byte)(this.g + color2.g);
        this.b = (byte)(this.b + color2.b);
        return this;
    }

    public Color sub(Color color2) {
        int ia = (this.a & 0xFF) - (color2.a & 0xFF);
        int ir = (this.r & 0xFF) - (color2.r & 0xFF);
        int ig = (this.g & 0xFF) - (color2.g & 0xFF);
        int ib = (this.b & 0xFF) - (color2.b & 0xFF);
        this.a = (byte)Math.max(ia, 0);
        this.r = (byte)Math.max(ir, 0);
        this.g = (byte)Math.max(ig, 0);
        this.b = (byte)Math.max(ib, 0);
        return this;
    }

    public Color invert() {
        this.a = (byte)(255 - (this.a & 0xFF));
        this.r = (byte)(255 - (this.r & 0xFF));
        this.g = (byte)(255 - (this.g & 0xFF));
        this.b = (byte)(255 - (this.b & 0xFF));
        return this;
    }

    public Color multiply(Color color2) {
        this.a = (byte)((double)(this.a & 0xFF) * ((double)(color2.a & 0xFF) / 255.0));
        this.r = (byte)((double)(this.r & 0xFF) * ((double)(color2.r & 0xFF) / 255.0));
        this.g = (byte)((double)(this.g & 0xFF) * ((double)(color2.g & 0xFF) / 255.0));
        this.b = (byte)((double)(this.b & 0xFF) * ((double)(color2.b & 0xFF) / 255.0));
        return this;
    }

    public Color scale(double d) {
        this.a = (byte)((double)(this.a & 0xFF) * d);
        this.r = (byte)((double)(this.r & 0xFF) * d);
        this.g = (byte)((double)(this.g & 0xFF) * d);
        this.b = (byte)((double)(this.b & 0xFF) * d);
        return this;
    }

    public Color interpolate(Color color2, double d) {
        return this.add(color2.copy().sub(this).scale(d));
    }

    public Color multiplyC(double d) {
        this.r = (byte)MathUtils.clip((double)(this.r & 0xFF) * d, 0.0, 255.0);
        this.g = (byte)MathUtils.clip((double)(this.g & 0xFF) * d, 0.0, 255.0);
        this.b = (byte)MathUtils.clip((double)(this.b & 0xFF) * d, 0.0, 255.0);
        return this;
    }

    @Override
    public abstract Color copy();

    public int rgb() {
        return (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int argb() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int rgba() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
    }

    public abstract Color set(int var1);

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public Color set(double r, double g, double b, double a) {
        return this.set((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b), (int)(255.0 * a));
    }

    public Color set(float r, float g, float b, float a) {
        return this.set((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a));
    }

    public Color set(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
        return this;
    }

    public Color set(double[] doubles) {
        return this.set(doubles[0], doubles[1], doubles[2], doubles[3]);
    }

    public Color set(float[] floats) {
        return this.set(floats[0], floats[1], floats[2], floats[3]);
    }

    public Color rF(float r) {
        this.r = (byte)(255.0f * r);
        return this;
    }

    public Color gF(float g) {
        this.g = (byte)(255.0f * g);
        return this;
    }

    public Color bF(float b) {
        this.b = (byte)(255.0f * b);
        return this;
    }

    public Color aF(float a) {
        this.a = (byte)(255.0f * a);
        return this;
    }

    public Color rF(int r) {
        this.r = (byte)r;
        return this;
    }

    public Color gF(int g) {
        this.g = (byte)g;
        return this;
    }

    public Color bF(int b) {
        this.b = (byte)b;
        return this;
    }

    public Color aF(int a) {
        this.a = (byte)a;
        return this;
    }

    public float rF() {
        return (float)this.r() / 255.0f;
    }

    public float gF() {
        return (float)this.g() / 255.0f;
    }

    public float bF() {
        return (float)this.b() / 255.0f;
    }

    public float aF() {
        return (float)this.a() / 255.0f;
    }

    public int r() {
        return this.r & 0xFF;
    }

    public int g() {
        return this.g & 0xFF;
    }

    public int b() {
        return this.b & 0xFF;
    }

    public int a() {
        return this.a & 0xFF;
    }

    public float[] getRGBA() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, (float)this.a / 255.0f};
    }

    public float[] getRGB() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public float[] getARGB() {
        return new float[]{(float)this.a / 255.0f, (float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public boolean equals(Color color) {
        return color != null && this.rgba() == color.rgba();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Color)) {
            return false;
        }
        Color color = (Color)o;
        if (this.r != color.r) {
            return false;
        }
        if (this.g != color.g) {
            return false;
        }
        if (this.b != color.b) {
            return false;
        }
        return this.a == color.a;
    }

    public int hashCode() {
        int result = this.r;
        result = 31 * result + this.g;
        result = 31 * result + this.b;
        result = 31 * result + this.a;
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[0x" + Integer.toHexString(this.pack()).toUpperCase() + "]";
    }
}

