/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.vec;

import committee.nova.mods.avaritia.api.util.java.Copyable;
import committee.nova.mods.avaritia.api.util.vec.Transformation;
import committee.nova.mods.avaritia.api.util.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Cuboid6
implements Copyable<Cuboid6> {
    public static Cuboid6 full = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public Vector3 min;
    public Vector3 max;

    public Cuboid6() {
        this(new Vector3(), new Vector3());
    }

    public Cuboid6(Vector3 min, Vector3 max) {
        this.min = min;
        this.max = max;
    }

    public Cuboid6(Vec3i min, Vec3i max) {
        this.min = Vector3.fromVec3i(min);
        this.max = Vector3.fromVec3i(max);
    }

    public Cuboid6(AABB aabb) {
        this.min = new Vector3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
        this.max = new Vector3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    public Cuboid6(CompoundTag tag) {
        this(Vector3.fromNBT(tag.m_128469_("min")), Vector3.fromNBT(tag.m_128469_("max")));
    }

    public Cuboid6(Cuboid6 cuboid) {
        this.min = cuboid.min.copy();
        this.max = cuboid.max.copy();
    }

    public Cuboid6(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min = new Vector3(minx, miny, minz);
        this.max = new Vector3(maxx, maxy, maxz);
    }

    public AABB aabb() {
        return new AABB(this.min.x, this.min.y, this.min.z, this.max.x, this.max.y, this.max.z);
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128365_("min", (Tag)this.min.writeToNBT(new CompoundTag()));
        tag.m_128365_("max", (Tag)this.max.writeToNBT(new CompoundTag()));
        return tag;
    }

    public Cuboid6 set(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min.set(minx, miny, minz);
        this.max.set(maxx, maxy, maxz);
        return this;
    }

    public Cuboid6 set(Vector3 min, Vector3 max) {
        return this.set(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public Cuboid6 set(Vec3i min, Vec3i max) {
        return this.set(min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_());
    }

    public Cuboid6 set(Cuboid6 c) {
        return this.set(c.min.x, c.min.y, c.min.z, c.max.x, c.max.y, c.max.z);
    }

    public Cuboid6 set(AABB bb) {
        return this.set(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
    }

    public Cuboid6 add(double dx, double dy, double dz) {
        this.min.add(dx, dy, dz);
        this.max.add(dx, dy, dz);
        return this;
    }

    public Cuboid6 add(double d) {
        return this.add(d, d, d);
    }

    public Cuboid6 add(Vector3 vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Cuboid6 add(Vec3i vec) {
        return this.add(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public Cuboid6 add(BlockPos pos) {
        return this.add(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Cuboid6 subtract(double dx, double dy, double dz) {
        this.min.subtract(dx, dy, dz);
        this.max.subtract(dx, dy, dz);
        return this;
    }

    public Cuboid6 subtract(double d) {
        return this.subtract(d, d, d);
    }

    public Cuboid6 subtract(Vector3 vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public Cuboid6 subtract(Vec3i vec) {
        return this.subtract(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public Cuboid6 subtract(Vec3 vec) {
        return this.subtract(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public Cuboid6 subtract(BlockPos pos) {
        return this.subtract(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Cuboid6 expand(double dx, double dy, double dz) {
        this.min.subtract(dx, dy, dz);
        this.max.add(dx, dy, dz);
        return this;
    }

    public Cuboid6 expand(double d) {
        return this.expand(d, d, d);
    }

    public Cuboid6 expand(Vector3 vec) {
        return this.expand(vec.x, vec.y, vec.z);
    }

    public Cuboid6 expandSide(Direction side, int amount) {
        switch (side.m_122421_()) {
            case NEGATIVE: {
                this.min.add(Vector3.fromVec3i(side.m_122436_()).multiply(amount));
                break;
            }
            case POSITIVE: {
                this.max.add(Vector3.fromVec3i(side.m_122436_()).multiply(amount));
            }
        }
        return this;
    }

    public Cuboid6 shrinkSide(Direction side, int amount) {
        this.expandSide(side, -amount);
        return this;
    }

    public Cuboid6 offset(Cuboid6 o) {
        this.min.add(o.min);
        this.max.add(o.max);
        return this;
    }

    public Cuboid6 enclose(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        if (this.min.x > minx) {
            this.min.x = minx;
        }
        if (this.min.y > miny) {
            this.min.y = miny;
        }
        if (this.min.z > minz) {
            this.min.z = minz;
        }
        if (this.max.x < maxx) {
            this.max.x = maxx;
        }
        if (this.max.y < maxy) {
            this.max.y = maxy;
        }
        if (this.max.z < maxz) {
            this.max.z = maxz;
        }
        return this;
    }

    public Cuboid6 enclose(double x, double y, double z) {
        return this.enclose(x, y, z, x, y, z);
    }

    public Cuboid6 enclose(Vector3 vec) {
        return this.enclose(vec.x, vec.y, vec.z, vec.x, vec.y, vec.z);
    }

    public Cuboid6 enclose(Cuboid6 c) {
        return this.enclose(c.min.x, c.min.y, c.min.z, c.max.x, c.max.y, c.max.z);
    }

    public boolean contains(double x, double y, double z) {
        return this.min.x - 1.0E-5 <= x && this.min.y - 1.0E-5 <= y && this.min.z - 1.0E-5 <= z && this.max.x + 1.0E-5 >= x && this.max.y + 1.0E-5 >= y && this.max.z + 1.0E-5 >= z;
    }

    public boolean contains(Vector3 vec) {
        return this.contains(vec.x, vec.y, vec.z);
    }

    public boolean intersects(Cuboid6 b) {
        return this.max.x - 1.0E-5 > b.min.x && this.max.y - 1.0E-5 > b.min.y && this.max.z - 1.0E-5 > b.min.z && b.max.x - 1.0E-5 > this.min.x && b.max.y - 1.0E-5 > this.min.y && b.max.z - 1.0E-5 > this.min.z;
    }

    public double volume() {
        return (this.max.x - this.min.x + 1.0) * (this.max.y - this.min.y + 1.0) * (this.max.z - this.min.z + 1.0);
    }

    public Vector3 center() {
        return this.min.copy().add(this.max).multiply(0.5);
    }

    public double getSideSize(Direction side) {
        return switch (side.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.max.x - this.min.x + 1.0;
            case Direction.Axis.Y -> this.max.y - this.min.y + 1.0;
            case Direction.Axis.Z -> this.max.z - this.min.z + 1.0;
        };
    }

    public double getSide(int side) {
        return switch (side) {
            case 0 -> this.min.y;
            case 1 -> this.max.y;
            case 2 -> this.min.z;
            case 3 -> this.max.z;
            case 4 -> this.min.x;
            case 5 -> this.max.x;
            default -> 0.0;
        };
    }

    public double getSide(Direction side) {
        return this.getSide(side.ordinal());
    }

    public Cuboid6 setSide(int side, double d) {
        switch (side) {
            case 0: {
                this.min.y = d;
                break;
            }
            case 1: {
                this.max.y = d;
                break;
            }
            case 2: {
                this.min.z = d;
                break;
            }
            case 3: {
                this.max.z = d;
                break;
            }
            case 4: {
                this.min.x = d;
                break;
            }
            case 5: {
                this.max.x = d;
            }
        }
        return this;
    }

    public Cuboid6 setSide(Direction side, double d) {
        return this.setSide(side.ordinal(), d);
    }

    public int hashCode() {
        long i = Double.doubleToLongBits(this.min.x);
        int j = (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.min.y);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.min.z);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.max.x);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.max.y);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.max.z);
        j = 31 * j + (int)(i ^ i >>> 32);
        return j;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Cuboid6)) {
            return false;
        }
        Cuboid6 c = (Cuboid6)obj;
        return this.min.equals(c.min) && this.max.equals(c.max);
    }

    public boolean equalsT(Cuboid6 c) {
        return this.min.equalsT(c.min) && this.max.equalsT(c.max);
    }

    @Override
    public Cuboid6 copy() {
        return new Cuboid6(this);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Cuboid: (" + String.valueOf(new BigDecimal(this.min.x, cont)) + ", " + String.valueOf(new BigDecimal(this.min.y, cont)) + ", " + String.valueOf(new BigDecimal(this.min.z, cont)) + ") -> (" + String.valueOf(new BigDecimal(this.max.x, cont)) + ", " + String.valueOf(new BigDecimal(this.max.y, cont)) + ", " + String.valueOf(new BigDecimal(this.max.z, cont)) + ")";
    }

    public Cuboid6 apply(Transformation t) {
        double temp;
        t.apply(this.min);
        t.apply(this.max);
        if (this.min.x > this.max.x) {
            temp = this.min.x;
            this.min.x = this.max.x;
            this.max.x = temp;
        }
        if (this.min.y > this.max.y) {
            temp = this.min.y;
            this.min.y = this.max.y;
            this.max.y = temp;
        }
        if (this.min.z > this.max.z) {
            temp = this.min.z;
            this.min.z = this.max.z;
            this.max.z = temp;
        }
        return this;
    }
}

