/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.render.CCRenderState;
import committee.nova.mods.avaritia.api.client.render.model.OBJParser;
import committee.nova.mods.avaritia.api.client.render.pipeline.IVertexOperation;
import committee.nova.mods.avaritia.api.client.util.color.Color;
import committee.nova.mods.avaritia.api.client.util.color.ColorRGBA;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GapingVoidRender
extends EntityRenderer<GapingVoidEntity> {
    public GapingVoidRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public static Color getColour(double age, double a) {
        double l = age / 186.0;
        double f = Math.max(0.0, (l - 0.95) / 0.050000000000000044);
        f = Math.max(f, 1.0 - l * 30.0);
        return new ColorRGBA(f, f, f, a);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GapingVoidEntity p_114482_) {
        return Res.VOID;
    }

    public void render(@NotNull GapingVoidEntity ent, float entityYaw, float ticks, @NotNull PoseStack stack, @NotNull MultiBufferSource buf, int packedLightIn) {
        double dz;
        double dy;
        float age = (float)ent.getAge() + ticks;
        Color color = GapingVoidRender.getColour(age, 1.0);
        double scale = GapingVoidEntity.getVoidScale(age);
        double halocoord = 0.58 * scale;
        double haloScaleDist = 2.2 * scale;
        Vec3 cam = this.f_114476_.f_114358_.m_90583_();
        double dx = ent.m_20185_() - cam.m_7096_();
        double len = Math.sqrt(dx * dx + (dy = ent.m_20186_() - cam.m_7098_()) * dy + (dz = ent.m_20189_() - cam.m_7094_()) * dz);
        if (len <= haloScaleDist) {
            double close = (haloScaleDist - len) / haloScaleDist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_((float)(Math.atan2(dx, dz) * 57.29577951308232)));
        stack.m_252781_(Axis.f_252529_.m_252977_((float)(Math.atan2(Math.sqrt(dx * dx + dz * dz), dy) * 57.29577951308232 + 90.0)));
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        VertexConsumer consumer = buf.m_6299_(RenderType.m_110473_((ResourceLocation)Res.VOID_HALO));
        PoseStack.Pose pose = stack.m_85850_();
        consumer.m_252986_(pose.m_252922_(), (float)(-halocoord), 0.0f, (float)(-halocoord)).m_6122_((int)color.r, (int)color.g, (int)color.b, (int)color.a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(packedLightIn).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), (float)(-halocoord), 0.0f, (float)halocoord).m_6122_((int)color.r, (int)color.g, (int)color.b, (int)color.a).m_7421_(0.0f, 1.0f).m_7122_(0, 10).m_85969_(packedLightIn).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), (float)halocoord, 0.0f, (float)halocoord).m_6122_((int)color.r, (int)color.g, (int)color.b, (int)color.a).m_7421_(1.0f, 1.0f).m_7122_(0, 10).m_85969_(packedLightIn).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), (float)halocoord, 0.0f, (float)(-halocoord)).m_6122_((int)color.r, (int)color.g, (int)color.b, (int)color.a).m_7421_(1.0f, 0.0f).m_7122_(0, 10).m_85969_(packedLightIn).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        stack.m_85841_((float)scale, (float)scale, (float)scale);
        CCRenderState cc = CCRenderState.instance();
        cc.reset();
        cc.bind(AvaritiaRenderTypes.VOID, buf, stack);
        cc.baseColour = color.rgba();
        new OBJParser(Const.rl("models/hemisphere.obj")).parse().get("model").render(cc, new IVertexOperation[0]);
        stack.m_85849_();
    }
}

