/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.Res;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ArcRender {
    public static final RenderType ARC_RENDER_TYPE = new RenderType.CompositeRenderType("arc_render_type", DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, 256, false, true, RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(Res.ARC_TEX, false, false)).m_173292_(RenderStateShard.f_173102_).m_110661_(RenderStateShard.f_110110_).m_110675_(RenderStateShard.f_110129_).m_110685_(RenderStateShard.f_110136_).m_110691_(false));
    private static final float THICKNESS_VARIATION = 0.4f;
    private static final float MIN_THICKNESS_FACTOR = 0.1f;
    private static final double EPSILON = 1.0E-6;

    public static void renderArc(PoseStack ps, MultiBufferSource mbs, long seed, float sx, float sy, float sz, float ex, float ey, float ez, float thickness, int segments) {
        Vec3 side;
        VertexConsumer vc = mbs.m_6299_(ARC_RENDER_TYPE);
        Matrix4f matrix = ps.m_85850_().m_252922_();
        Random rnd = new Random(seed);
        Vec3 end = new Vec3((double)ex, (double)ey, (double)ez);
        Vec3 start = new Vec3((double)sx, (double)sy, (double)sz);
        Vec3 delta = end.m_82546_(start);
        if (delta.m_82556_() < 1.0E-12) {
            return;
        }
        Vec3 direction = delta.m_82541_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(direction.m_7098_()) > 0.999999) {
            up = new Vec3(1.0, 0.0, 0.0);
        }
        if ((side = direction.m_82537_(up)).m_82556_() < 1.0E-12 && (side = direction.m_82537_(up = new Vec3(0.0, 0.0, 1.0))).m_82556_() < 1.0E-12) {
            if (direction.m_82556_() > 1.0E-12) {
                Vec3 arbitraryNonParallel = Math.abs(direction.m_7096_()) < 0.9 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
                side = direction.m_82537_(arbitraryNonParallel);
                if (side.m_82556_() < 1.0E-12) {
                    return;
                }
            } else {
                return;
            }
        }
        side = side.m_82541_();
        Vec3 renderUp = side.m_82537_(direction).m_82541_();
        Vec3 prevL = start;
        Vec3 prevR = start;
        float baseHalfThickness = thickness * 0.5f;
        for (int i = 1; i <= segments; ++i) {
            float t = (float)i / (float)segments;
            Vec3 currentMidpoint = start.m_82549_(delta.m_82490_((double)t));
            float displacementMagnitude = baseHalfThickness * ((float)Math.PI * 2);
            float falloff = 1.0f - (float)Math.pow(2.0 * (double)t - 1.0, 2.0);
            displacementMagnitude *= falloff;
            double angle = rnd.nextDouble() * 6.2831854820251465;
            Vec3 displacementDir = side.m_82490_(Math.cos(angle)).m_82549_(renderUp.m_82490_(Math.sin(angle)));
            Vec3 currentPos = currentMidpoint.m_82549_(displacementDir.m_82490_((double)(displacementMagnitude *= rnd.nextFloat() * 2.0f - 1.0f)));
            float currentHalfThickness = baseHalfThickness;
            currentHalfThickness *= 1.0f + 0.4f * (rnd.nextFloat() * 2.0f - 1.0f);
            currentHalfThickness = Math.max(baseHalfThickness * 0.1f, currentHalfThickness);
            Vec3 currentL = currentPos.m_82546_(side.m_82490_((double)currentHalfThickness));
            Vec3 currentR = currentPos.m_82549_(side.m_82490_((double)currentHalfThickness));
            float u0 = (float)(i - 1) / (float)segments;
            float u1 = (float)i / (float)segments;
            vc.m_252986_(matrix, (float)prevL.m_7096_(), (float)prevL.m_7098_(), (float)prevL.m_7094_()).m_7421_(u0, 0.0f).m_5752_();
            vc.m_252986_(matrix, (float)prevR.m_7096_(), (float)prevR.m_7098_(), (float)prevR.m_7094_()).m_7421_(u0, 1.0f).m_5752_();
            vc.m_252986_(matrix, (float)currentR.m_7096_(), (float)currentR.m_7098_(), (float)currentR.m_7094_()).m_7421_(u1, 1.0f).m_5752_();
            vc.m_252986_(matrix, (float)currentL.m_7096_(), (float)currentL.m_7098_(), (float)currentL.m_7094_()).m_7421_(u1, 0.0f).m_5752_();
            prevL = currentL;
            prevR = currentR;
        }
    }
}

