/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.api.client.screen.component.SimpleScrollBar;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.common.net.chest.C2SInfinityChestFilterPack;
import committee.nova.mods.avaritia.core.chest.ClientChestHandler;
import committee.nova.mods.avaritia.core.chest.ClientChestManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class InfinityChestScreen
extends BaseContainerScreen<InfinityChestMenu> {
    private int blitOffset;
    private static final ResourceLocation GUI_IMG = Res.INFINITY_CHEST_TEX;
    private final String ownerName;
    private String lastHoveredItem = "";
    private long lastCount = 0L;
    private String lastFormatCountTemp = "";
    private SortButton sortButton;
    private ItemScrollBar scrollBar;
    private EditBox searchBox;

    public InfinityChestScreen(InfinityChestMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, null, 302, 274, 550, 550);
        this.ownerName = ClientChestManager.getInstance().getUserName(((InfinityChestMenu)this.m_6262_()).owner);
    }

    @Override
    protected void subInit() {
        super.subInit();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.scrollBar = new ItemScrollBar(this.f_97735_ + 282, this.f_97736_ + 16, 12, 160);
        this.scrollBar.setScrolledOn(((InfinityChestMenu)this.f_97732_).chestContainer.getScrollOn());
        this.m_142416_((GuiEventListener)this.scrollBar);
        this.m_142416_((GuiEventListener)new ToggleLockButton(this.f_97735_ + 231, this.f_97736_ + 187));
        this.sortButton = new SortButton(this.f_97735_ + 249, this.f_97736_ + 187);
        this.m_142416_((GuiEventListener)this.sortButton);
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 187, this.f_97736_ + 4, 89, 10, (Component)Component.m_237115_((String)"gui.avaritia.search"));
        this.searchBox.m_94199_(64);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94144_(((InfinityChestMenu)this.f_97732_).filter);
        this.m_142416_((GuiEventListener)this.searchBox);
        ((InfinityChestMenu)this.f_97732_).chestContainer.refreshContainer(true);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_ + 50, this.f_97731_ + 108, 0x404040, false);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        pGuiGraphics.m_280398_(GUI_IMG, x, y, this.blitOffset, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.bgImgWidth, this.bgImgHeight);
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderDummyCount(pGuiGraphics);
    }

    public void m_280092_(@NotNull GuiGraphics guiGraphics, Slot slot) {
        if (slot.f_40219_ >= 36) {
            ItemStack stack = slot.m_7993_();
            int originalCount = stack.m_41613_();
            if (stack.m_41613_() > 1) {
                stack.m_41764_(1);
                super.m_280092_(guiGraphics, slot);
                stack.m_41764_(originalCount);
            } else {
                super.m_280092_(guiGraphics, slot);
            }
            return;
        }
        super.m_280092_(guiGraphics, slot);
    }

    public void renderDummyCount(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        for (int i = 0; i < ((InfinityChestMenu)this.f_97732_).chestContainer.formatCount.size(); ++i) {
            Slot slot = (Slot)((InfinityChestMenu)this.f_97732_).f_38839_.get(i + 36);
            String count = ((InfinityChestMenu)this.f_97732_).chestContainer.formatCount.get(i);
            this.setBlitOffset(100);
            RenderSystem.enableDepthTest();
            float fontSize = 0.5f;
            poseStack.m_85836_();
            poseStack.m_85837_((double)(this.f_97735_ + slot.f_40220_), (double)(this.f_97736_ + slot.f_40221_), 300.0);
            poseStack.m_85841_(fontSize, fontSize, 1.0f);
            float f = (16.0f - (float)this.f_96547_.m_92895_(count) * fontSize) / fontSize;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.drawString(this.f_96547_, count, f, (16.0f - 9.0f * fontSize) / fontSize, 0xFFFFFF, false);
            poseStack.m_85849_();
            this.setBlitOffset(0);
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_280072_(GuiGraphics pPoseStack, int pX, int pY) {
        if (this.f_97734_ != null) {
            if (this.f_97734_.f_40219_ >= 36) {
                if (((InfinityChestMenu)this.f_97732_).m_142621_().m_41613_() == 1) {
                    this.renderObjectStorageTooltip(pPoseStack, pX, pY);
                } else {
                    this.renderCounterTooltip(pPoseStack, pX, pY);
                }
            } else if (!this.f_97734_.m_7993_().m_41619_() && ((InfinityChestMenu)this.f_97732_).m_142621_().m_41619_()) {
                pPoseStack.m_280153_(this.f_96547_, this.f_97734_.m_7993_(), pX, pY);
            }
        } else if (this.searchBox.m_274382_()) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.avaritia.search.tip1"));
            list.add(Component.m_237115_((String)"gui.avaritia.search.tip2"));
            list.add(Component.m_237115_((String)"gui.avaritia.search.tip3"));
            pPoseStack.m_280666_(this.f_96547_, list, pX, pY);
        }
    }

    private void renderCounterTooltip(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        if (this.f_97734_.f_40219_ - 36 >= ((InfinityChestMenu)this.f_97732_).chestContainer.viewingObject.size()) {
            return;
        }
        String hoveredObject = ((InfinityChestMenu)this.f_97732_).chestContainer.viewingObject.get(this.f_97734_.f_40219_ - 36);
        List components = InfinityChestScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)this.f_97734_.m_7993_());
        long count = ((InfinityChestMenu)this.f_97732_).chest.getRealItemAmount(hoveredObject);
        if (!hoveredObject.equals(this.lastHoveredItem)) {
            String formatCount = StorageUtils.DECIMAL_FORMAT.format(count);
            components.add(Component.m_237113_((String)formatCount));
            this.lastHoveredItem = hoveredObject;
            this.lastCount = count;
            this.lastFormatCountTemp = formatCount;
        } else if (count == this.lastCount) {
            components.add(Component.m_237113_((String)this.lastFormatCountTemp));
        } else {
            Object formatCount = StorageUtils.DECIMAL_FORMAT.format(count);
            long count2 = count - this.lastCount;
            String formatCount2 = StorageUtils.DECIMAL_FORMAT.format(count2);
            formatCount = count2 >= 0L ? (String)formatCount + "  |  +\u00a7a" + formatCount2 : (String)formatCount + "  |  \u00a7c" + formatCount2;
            components.add(Component.m_237113_((String)formatCount));
            this.lastCount = count;
            this.lastFormatCountTemp = formatCount;
        }
        pPoseStack.m_280677_(this.f_96547_, components, this.f_97734_.m_7993_().m_150921_(), pMouseX, pMouseY);
    }

    private void renderObjectStorageTooltip(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        boolean hasCapability;
        ItemStack carried = ((InfinityChestMenu)this.f_97732_).m_142621_();
        boolean bl = hasCapability = carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() || carried.getCapability(ForgeCapabilities.ENERGY).isPresent() || carried.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
        if (hasCapability) {
            ArrayList components = Lists.newArrayList();
            if (this.f_97734_.f_40219_ - 36 < ((InfinityChestMenu)this.f_97732_).chestContainer.viewingObject.size()) {
                components.add(Component.m_237110_((String)"gui.avaritia.capability.tip1", (Object[])new Object[]{this.f_97734_.m_7993_().m_41786_()}));
            }
            components.add(Component.m_237115_((String)"gui.avaritia.capability.tip2"));
            components.add(Component.m_237115_((String)"gui.avaritia.capability.tip3"));
            pPoseStack.m_280677_(this.f_96547_, (List)components, ItemStack.f_41583_.m_150921_(), pMouseX, pMouseY);
        } else {
            this.renderCounterTooltip(pPoseStack, pMouseX, pMouseY);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.searchBox.m_93696_()) {
            this.searchBox.m_94120_();
        }
    }

    public void m_7379_() {
        NetworkHandler.CHANNEL.sendToServer((Object)new C2SInfinityChestFilterPack(((InfinityChestMenu)this.f_97732_).f_38840_, ((InfinityChestMenu)this.f_97732_).filter));
        ((ClientChestHandler)((InfinityChestMenu)this.f_97732_).chest).removeListener();
        super.m_7379_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 1 && this.searchBox.m_5953_(pMouseX, pMouseY)) {
            ((InfinityChestMenu)this.f_97732_).filter = "";
            this.searchBox.m_94144_("");
            ((InfinityChestMenu)this.f_97732_).chestContainer.refreshContainer(true);
            this.searchBox.m_93692_(true);
            this.searchBox.m_94186_(true);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrollBar.isScrolling()) {
            this.scrollBar.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.m_6348_(pMouseX, pMouseY, pButton);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchBox.m_93696_() && pKeyCode >= 48 && pKeyCode <= 90) {
            return true;
        }
        if (pKeyCode == 340) {
            ((InfinityChestMenu)this.f_97732_).LShifting = true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        String s;
        if (this.searchBox.m_93696_() && !(s = this.searchBox.m_94155_().toLowerCase()).equals(((InfinityChestMenu)this.f_97732_).filter)) {
            ((InfinityChestMenu)this.f_97732_).filter = s;
            ((InfinityChestMenu)this.f_97732_).chestContainer.refreshContainer(true);
        }
        if (pKeyCode == 340) {
            ((InfinityChestMenu)this.f_97732_).LShifting = false;
            ((InfinityChestMenu)this.f_97732_).chestContainer.refreshContainer(true);
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)(this.f_97735_ + 5) && pMouseX <= (double)(this.f_97735_ + 214) && pMouseY >= (double)(this.f_97736_ + 17) && pMouseY <= (double)(this.f_97736_ + 18 + 119) && this.scrollBar.canScroll()) {
            if (pDelta <= 0.0) {
                this.scrollBar.setScrolledOn(((InfinityChestMenu)this.f_97732_).chestContainer.onMouseScrolled(false));
            } else {
                this.scrollBar.setScrolledOn(((InfinityChestMenu)this.f_97732_).chestContainer.onMouseScrolled(true));
            }
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    protected boolean m_6774_(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        return (pMouseX -= (double)i) >= (double)pX && pMouseX < (double)(pX + pWidth) && (pMouseY -= (double)j) >= (double)pY && pMouseY < (double)(pY + pHeight);
    }

    private void toggleLock() {
        if (((InfinityChestMenu)this.f_97732_).owner.equals(((InfinityChestMenu)this.f_97732_).player.m_20148_()) || ((InfinityChestMenu)this.f_97732_).owner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            ((InfinityChestMenu)this.f_97732_).locked = !((InfinityChestMenu)this.f_97732_).locked;
            this.searchBox.m_93692_(false);
            NetworkHandler.CHANNEL.sendToServer((Object)new C2SInfinityChestFilterPack(((InfinityChestMenu)this.f_97732_).f_38840_, ((InfinityChestMenu)this.f_97732_).filter));
            this.f_96541_.f_91072_.m_105208_(((InfinityChestMenu)this.f_97732_).f_38840_, 0);
        }
    }

    private void cycleSort() {
        if (InputConstants.m_84830_((long)this.getMinecraft().m_91268_().m_85439_(), (int)340)) {
            ((InfinityChestMenu)this.f_97732_).reverseSort();
            this.f_96541_.f_91072_.m_105208_(((InfinityChestMenu)this.f_97732_).f_38840_, 2);
        } else {
            ((InfinityChestMenu)this.f_97732_).nextSort();
            this.f_96541_.f_91072_.m_105208_(((InfinityChestMenu)this.f_97732_).f_38840_, 1);
        }
    }

    private String getSortKey(int sortType) {
        return switch (sortType) {
            case 0, 1 -> "gui.avaritia.sort.id";
            case 2, 3 -> "gui.avaritia.sort.nid";
            case 4, 5 -> "gui.avaritia.sort.mirror_id";
            case 6, 7 -> "gui.avaritia.sort.count";
            default -> "";
        };
    }

    @Generated
    public void setBlitOffset(int blitOffset) {
        this.blitOffset = blitOffset;
    }

    @Generated
    public int getBlitOffset() {
        return this.blitOffset;
    }

    private class ItemScrollBar
    extends SimpleScrollBar {
        private int lastObjectListSize;

        public ItemScrollBar(int x, int y, int weight, int height) {
            super(x, y, weight, height);
            this.setScrollTagSize();
            this.lastObjectListSize = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).chestContainer.sortedItems.size();
        }

        public void setScrollTagSize() {
            double v = (double)this.f_93619_ * (9.0 / Math.ceil((double)((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).chestContainer.sortedItems.size() / 15.0));
            this.setScrollTagSize(v);
        }

        @Override
        public void draggedTo(double scrolledOn) {
            ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).chestContainer.onScrollTo(scrolledOn);
        }

        @Override
        public void beforeRender() {
            if (((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).chestContainer.sortedItems.size() != this.lastObjectListSize) {
                this.setScrollTagSize();
                this.lastObjectListSize = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).chestContainer.sortedItems.size();
            }
        }
    }

    private class ToggleLockButton
    extends ImageButton {
        public ToggleLockButton(int pX, int pY) {
            super(pX, pY, 17, 18, 303, 36, GUI_IMG, pButton -> InfinityChestScreen.this.toggleLock());
            MutableComponent componentB = Component.m_237110_((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7c" + InfinityChestScreen.this.ownerName});
            MutableComponent componentC = Component.m_237115_((String)"gui.avaritia.public");
            if (((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).locked) {
                this.m_257544_(Tooltip.m_257550_((Component)componentB));
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)componentC));
            }
        }

        @ParametersAreNonnullByDefault
        public void m_87963_(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int uOffset;
            int n = uOffset = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).locked ? 303 : 320;
            if (this.f_93622_) {
                pPoseStack.m_280163_(GUI_IMG, this.m_252754_(), this.m_252907_(), (float)uOffset, (float)(this.f_94225_ + 18), this.f_93618_, this.f_93619_, 550, 550);
            } else {
                pPoseStack.m_280163_(GUI_IMG, this.m_252754_(), this.m_252907_(), (float)uOffset, (float)this.f_94225_, this.f_93618_, this.f_93619_, 550, 550);
            }
        }
    }

    private class SortButton
    extends ImageButton {
        public SortButton(int pX, int pY) {
            super(pX, pY, 17, 18, 303, 0, GUI_IMG, pButton -> InfinityChestScreen.this.cycleSort());
        }

        @ParametersAreNonnullByDefault
        public void m_87963_(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            int xOffset = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).sortType * 17 + this.f_94224_;
            if (this.f_93622_) {
                pPoseStack.m_280163_(GUI_IMG, this.m_252754_(), this.m_252907_(), (float)xOffset, (float)(this.f_94225_ + 18), this.f_93618_, this.f_93619_, 550, 550);
            } else {
                pPoseStack.m_280163_(GUI_IMG, this.m_252754_(), this.m_252907_(), (float)xOffset, (float)this.f_94225_, this.f_93618_, this.f_93619_, 550, 550);
            }
            list.add(Component.m_237115_((String)InfinityChestScreen.this.getSortKey(((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).sortType)).m_7532_());
            if (((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).f_97732_).sortType % 2 == 0) {
                list.add(Component.m_237115_((String)"gui.avaritia.sort.ascending").m_7532_());
            } else {
                list.add(Component.m_237115_((String)"gui.avaritia.sort.descending").m_7532_());
            }
            list.add(Component.m_237115_((String)"gui.avaritia.line").m_7532_());
            list.add(Component.m_237115_((String)"gui.avaritia.sort.tip1").m_7532_());
            list.add(Component.m_237115_((String)"gui.avaritia.sort.tip2").m_7532_());
            if (this.f_93622_) {
                InfinityChestScreen.this.m_257959_(list);
            }
        }
    }
}

