/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.client.screen.side.SideConfigButton;
import committee.nova.mods.avaritia.common.menu.NeutronCompressorMenu;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class NeutronCompressorScreen
extends BaseContainerScreen<NeutronCompressorMenu> {
    private Button lockButton;
    private Button ejectButton;
    private Button configButton;

    public NeutronCompressorScreen(NeutronCompressorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Res.NEUTRON_COMPRESSOR_TEX);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.lockButton = new LockButton(x + 40, y + 55);
        this.ejectButton = new EjectButton(x + 40, y + 20);
        this.configButton = new SideConfigButton(this, x - 20, y);
        this.m_142416_((GuiEventListener)this.lockButton);
        this.m_142416_((GuiEventListener)this.ejectButton);
        this.m_142416_((GuiEventListener)this.configButton);
        this.lockButton.m_93666_((Component)Component.m_237113_((String)(this.isRecipeLocked() ? "\ud83d\udd12" : "\ud83d\udd13")));
    }

    private void lockRecipe() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            NetworkHandler.sendCompressorLockPacket(((NeutronCompressorMenu)this.f_97732_).getBlockPos(), !this.isRecipeLocked());
            this.lockButton.m_93666_((Component)Component.m_237113_((String)(!this.isRecipeLocked() ? "\ud83d\udd12" : "\ud83d\udd13")));
        }
    }

    private void ejectMaterials() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            NetworkHandler.sendCompressorEjectPacket(((NeutronCompressorMenu)this.f_97732_).getBlockPos());
        }
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (pMouseX > x + 63 && pMouseX < x + 79 && pMouseY > y + 35 && pMouseY < y + 51) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(ModTooltips.EMPTY.color(ChatFormatting.WHITE).build());
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                MutableComponent text = Component.m_237113_((String)(NeutronCompressorScreen.number(this.getMaterialCount()) + " / " + NeutronCompressorScreen.number(this.getMaterialsRequired())));
                tooltip.add(text);
            }
            pGuiGraphics.m_280666_(this.f_96547_, tooltip, pMouseX, pMouseY);
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        stack.m_280056_(this.f_96547_, title, this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2, 6, 0x404040, false);
        stack.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, 0x404040, false);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(16);
                pGuiGraphics.m_280218_(Res.NEUTRON_COMPRESSOR_TEX, x + 63, y + 35, 176, 18, i2 + 1, 16);
            }
            if (this.getProgress() > 0 && this.getMaterialCount() >= this.getMaterialsRequired()) {
                i2 = this.getProgressBarScaled(22);
                pGuiGraphics.m_280218_(Res.NEUTRON_COMPRESSOR_TEX, x + 89, y + 35, 176, 0, i2 + 1, 16);
            }
        }
    }

    private Component getMaterialStackDisplayName() {
        NeutronCompressorMenu container;
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_((container = (NeutronCompressorMenu)this.m_6262_()).getBlockPos())) instanceof NeutronCompressorTile) {
            NeutronCompressorTile compressor = (NeutronCompressorTile)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.m_41786_();
        }
        return Component.m_237113_((String)"");
    }

    public boolean hasRecipe() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().hasMaterialStack();
    }

    public int getProgress() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getProgress();
    }

    public int getMaterialCount() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().getMaterialCount();
    }

    public int getMaterialsRequired() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().getMaterialsRequired();
    }

    public int getTimeRequired() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().getTimeRequired();
    }

    public int getMaterialBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public boolean isRecipeLocked() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().isRecipeLocked();
    }

    public boolean canEjectMaterials() {
        if (((NeutronCompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorMenu)this.f_97732_).getTileEntity().getMaterialCount() > 0;
    }

    private class LockButton
    extends ImageButton {
        private final List<FormattedCharSequence> tips;

        public LockButton(int pX, int pY) {
            super(pX, pY, 14, 13, 177, 47, Res.NEUTRON_COMPRESSOR_TEX, pButton -> NeutronCompressorScreen.this.lockRecipe());
            this.tips = new ArrayList<FormattedCharSequence>();
            if (NeutronCompressorScreen.this.isRecipeLocked()) {
                this.tips.add(Component.m_237113_((String)"\u5df2\u9501\u5b9a\u914d\u65b9").m_130940_(ChatFormatting.GREEN).m_7532_());
                this.tips.add(Component.m_237113_((String)"\u70b9\u51fb\u89e3\u9501\u914d\u65b9").m_130940_(ChatFormatting.GRAY).m_7532_());
            } else {
                this.tips.add(Component.m_237113_((String)"\u672a\u9501\u5b9a\u914d\u65b9").m_130940_(ChatFormatting.YELLOW).m_7532_());
                this.tips.add(Component.m_237113_((String)"\u6709\u914d\u65b9\u65f6\u53ef\u70b9\u51fb\u9501\u5b9a").m_130940_(ChatFormatting.GRAY).m_7532_());
            }
        }

        @ParametersAreNonnullByDefault
        public void m_87963_(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.f_93622_) {
                if (NeutronCompressorScreen.this.isRecipeLocked()) {
                    pPoseStack.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)(this.f_94224_ + 14 + 1), (float)(this.f_94225_ + 13 + 1), this.f_93618_, this.f_93619_, 256, 256);
                } else {
                    pPoseStack.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)(this.f_94224_ + 14 + 1), (float)this.f_94225_, this.f_93618_, this.f_93619_, 256, 256);
                }
                NeutronCompressorScreen.this.m_257959_(this.tips);
            } else if (NeutronCompressorScreen.this.isRecipeLocked()) {
                pPoseStack.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)this.f_94224_, (float)(this.f_94225_ + 13 + 1), this.f_93618_, this.f_93619_, 256, 256);
            } else {
                pPoseStack.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)this.f_94224_, (float)this.f_94225_, this.f_93618_, this.f_93619_, 256, 256);
            }
        }
    }

    private class EjectButton
    extends ImageButton {
        private final List<FormattedCharSequence> tips;

        public EjectButton(int pX, int pY) {
            super(pX, pY, 14, 11, 177, 35, Res.NEUTRON_COMPRESSOR_TEX, pButton -> NeutronCompressorScreen.this.ejectMaterials());
            this.tips = new ArrayList<FormattedCharSequence>();
            this.tips.add(Component.m_237113_((String)"\u5f39\u51fa\u6750\u6599").m_130940_(ChatFormatting.AQUA).m_7532_());
            this.tips.add(Component.m_237113_((String)"\u70b9\u51fb\u5f39\u51fa\u6240\u6709\u6750\u6599\u5230\u7269\u54c1\u680f").m_130940_(ChatFormatting.GRAY).m_7532_());
        }

        @ParametersAreNonnullByDefault
        public void m_87963_(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.f_93622_) {
                NeutronCompressorScreen.this.m_257959_(this.tips);
                pPoseStack.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)(this.f_94224_ + 14 + 1), (float)this.f_94225_, this.f_93618_, this.f_93619_, 256, 256);
            } else {
                pPoseStack.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)this.f_94224_, (float)this.f_94225_, this.f_93618_, this.f_93619_, 256, 256);
            }
        }
    }
}

