/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.chest;

import committee.nova.mods.avaritia.common.tile.CompressedChestTile;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressedChestBlock
extends ChestBlock {
    public CompressedChestBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_(), () -> (BlockEntityType)ModTileEntities.compressed_chest_tile.get());
    }

    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        BlockEntity tile;
        if (!level.m_5776_() && (tile = level.m_7702_(pos)) instanceof CompressedChestTile) {
            CompressedChestTile chestTile = (CompressedChestTile)tile;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)chestTile, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new CompressedChestTile(pPos, pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = pContext.m_8125_().m_122424_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_51478_, (Comparable)direction)).m_61124_((Property)f_51479_, (Comparable)chesttype)).m_61124_((Property)f_51480_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.m_5776_()) {
            return;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (pStack.m_41783_() != null && blockentity instanceof CompressedChestTile) {
            CompressedChestTile chestTile = (CompressedChestTile)blockentity;
            chestTile.setChestTag(pStack.m_41783_());
        }
    }

    public void m_6807_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        CompressedChestTile chestTile;
        if (pLevel.m_5776_()) {
            return;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        CompoundTag nameTag = null;
        CompoundTag countTag = null;
        CompoundTag nbtTag = null;
        if (blockentity instanceof CompressedChestTile && (chestTile = (CompressedChestTile)blockentity).getChestTag() != null) {
            CompoundTag chestTag = chestTile.getChestTag();
            if (chestTag.m_128441_("name")) {
                nameTag = chestTag.m_128469_("name");
            }
            if (chestTag.m_128441_("count")) {
                countTag = chestTag.m_128469_("count");
            }
            if (chestTag.m_128441_("nbt")) {
                nbtTag = chestTag.m_128469_("nbt");
            }
        }
        if (nameTag != null && countTag != null) {
            Container container = (Container)blockentity;
            for (String index : nameTag.m_128431_()) {
                String name = nameTag.m_128461_(index);
                Item newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
                if (newItem == null) continue;
                ItemStack is = new ItemStack((ItemLike)newItem);
                is.m_41764_(countTag.m_128451_(index));
                if (nbtTag != null && !nbtTag.m_128469_(index).m_128456_()) {
                    is.m_41751_(nbtTag.m_128469_(index));
                }
                container.m_6836_(Integer.parseInt(index), is);
            }
        }
    }

    public void m_6810_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            CompoundTag chestTag = new CompoundTag();
            int stackCount = 0;
            if (blockentity instanceof Container) {
                Container container = (Container)blockentity;
                CompoundTag nameTag = new CompoundTag();
                CompoundTag countTag = new CompoundTag();
                CompoundTag nbtTag = new CompoundTag();
                for (int i = 0; i < container.m_6643_(); ++i) {
                    ItemStack item = container.m_8020_(i);
                    if (item.m_41619_()) continue;
                    ++stackCount;
                    nameTag.m_128359_(String.valueOf(i), ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)item.m_41720_()).get()).m_135782_().toString());
                    countTag.m_128405_(String.valueOf(i), item.m_41613_());
                    if (item.m_41783_() == null) continue;
                    nbtTag.m_128365_(String.valueOf(i), (Tag)item.m_41783_());
                }
                chestTag.m_128365_("name", (Tag)nameTag);
                chestTag.m_128365_("count", (Tag)countTag);
                chestTag.m_128365_("nbt", (Tag)nbtTag);
                chestTag.m_128405_("stackCount", stackCount);
            }
            if (blockentity instanceof CompressedChestTile) {
                CompressedChestTile chestTile = (CompressedChestTile)blockentity;
                chestTile.setChestTag(chestTag);
            }
            pLevel.m_46747_(pPos);
        }
    }

    public void m_6240_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            ItemStack pStack = new ItemStack((ItemLike)((Block)ModBlocks.compressed_chest.get()).m_5456_());
            if (pBlockEntity instanceof CompressedChestTile) {
                CompressedChestTile chestTile = (CompressedChestTile)pBlockEntity;
                pStack.m_41751_(chestTile.getChestTag());
            }
            CompressedChestBlock.m_49840_((Level)serverLevel, (BlockPos)pPos, (ItemStack)pStack);
            pState.m_222967_(serverLevel, pPos, pTool, false);
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        int stackCount = 0;
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_("stackCount")) {
            stackCount = pStack.m_41783_().m_128451_("stackCount");
        }
        pTooltip.add((Component)Component.m_237113_((String)String.format("%s/243", stackCount)));
    }
}

