/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.chest;

import committee.nova.mods.avaritia.api.common.block.BaseTileEntityBlock;
import committee.nova.mods.avaritia.common.tile.InfinityChestTile;
import committee.nova.mods.avaritia.core.chest.ServerChestHandler;
import committee.nova.mods.avaritia.core.chest.ServerChestManager;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityChestBlock
extends BaseTileEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public InfinityChestBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_280658_(NoteBlockInstrument.BASS).m_60913_(30.0f, 1200.0f).m_60918_(SoundType.f_56744_).m_60953_(b -> 15).m_60922_((state, getter, pos, entityType) -> false).m_60960_((state, getter, pos) -> false).m_278183_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AABB;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction2;
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = context.m_7078_();
        Direction direction1 = context.m_43719_();
        if (direction1.m_122434_().m_122479_() && flag && (direction2 = this.candidatePartnerFacing(context, direction1.m_122424_())) != null && direction2.m_122434_() != direction1.m_122434_()) {
            direction = direction2;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction));
        return blockstate.m_60713_((Block)this) ? (Direction)blockstate.m_61143_((Property)FACING) : null;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new InfinityChestTile(pos, state);
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        CompoundTag nbt;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (!pStack.m_41782_()) {
            return;
        }
        if (pStack.m_41783_().m_128441_("BlockEntityTag") && (nbt = pStack.m_41783_().m_128469_("BlockEntityTag")).m_128441_("owner") && nbt.m_128441_("channelID")) {
            UUID owner = nbt.m_128342_("owner");
            UUID channelID = nbt.m_128342_("channelID");
            ServerChestHandler channel = ServerChestManager.getInstance().getChest(owner, channelID);
            int i = 0;
            int j = 0;
            for (String item : channel.storageItems.keySet()) {
                ++j;
                if (i > 4) continue;
                ++i;
                MutableComponent textComponent = StorageUtils.getItem(item).m_7968_().m_41786_().m_6881_();
                textComponent.m_130946_(" x").m_130946_(String.format("%,d", channel.storageItems.get(item)));
                pTooltip.add((Component)textComponent);
            }
            if (j - i > 0) {
                pTooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        if (pPlacer instanceof ServerPlayer) {
            InfinityChestTile blockEntity;
            ServerPlayer player = (ServerPlayer)pPlacer;
            if (!pStack.m_41784_().m_128441_("BlockEntityTag") && (blockEntity = (InfinityChestTile)pLevel.m_7702_(pPos)) != null) {
                blockEntity.setOwner(player.m_20148_());
                blockEntity.setChannelId(UUID.randomUUID());
                ServerChestManager.getInstance().tryAddChest(player, blockEntity.getChannelID());
            }
        }
    }

    public void m_5707_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        BlockEntity blockEntity;
        if (!pLevel.m_5776_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof InfinityChestTile) {
            InfinityChestTile infinityChestTile = (InfinityChestTile)blockEntity;
            if (pLevel.m_46469_().m_46207_(GameRules.f_46136_)) {
                ItemStack stack = new ItemStack((ItemLike)this);
                infinityChestTile.m_187476_(stack);
                InfinityChestBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)stack);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        BlockEntity tile;
        if (!level.m_5776_() && !player.m_5833_() && (tile = level.m_7702_(pos)) instanceof InfinityChestTile) {
            InfinityChestTile chestTile = (InfinityChestTile)tile;
            if (chestTile.getOwner() == null) {
                chestTile.setOwner(player.m_20148_());
                chestTile.setLocked(false);
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)chestTile, buf -> {
                buf.m_130064_(pos);
                buf.m_130077_(chestTile.getOwner());
                buf.writeBoolean(chestTile.isLocked());
                buf.m_130072_(chestTile.getFilter(), 64);
                buf.writeByte((int)chestTile.getSortType());
                buf.m_130077_(chestTile.getChannelID());
            });
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected <T extends BlockEntity> BlockEntityTicker<T> getClientTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return InfinityChestBlock.createTicker(type, (BlockEntityType)ModTileEntities.infinity_chest_tile.get(), InfinityChestTile::lidAnimateTick);
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }
}

