/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class GapingVoidEntity
extends Entity {
    public static final EntityDataAccessor<Integer> AGE_PARAMETER = SynchedEntityData.m_135353_(GapingVoidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int maxLifetime = 186;
    public static final Predicate<Entity> SUCK_PREDICATE = input -> {
        if (input instanceof Player) {
            Player p = (Player)input;
            return !p.m_7500_() || !p.m_21255_();
        }
        return true;
    };
    public static final Predicate<Entity> COMNOM_PREDICATE = input -> {
        if (!(input instanceof LivingEntity)) {
            return false;
        }
        if (input instanceof Player) {
            Player p = (Player)input;
            return !p.m_7500_();
        }
        return !(input instanceof ImmortalItemEntity);
    };
    public static double collapse = 0.95;
    public static double suckRange = 20.0;
    private FakePlayer fakePlayer;
    private LivingEntity user;

    public GapingVoidEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19811_ = true;
        if (this.m_9236_() instanceof ServerLevel) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.m_9236_()), (GameProfile)Const.AVARITIA_FAKE_PLAYER);
        }
    }

    public GapingVoidEntity(Level level) {
        this((EntityType)ModEntities.GAPING_VOID.get(), level);
    }

    public GapingVoidEntity(Level level, LivingEntity shooter) {
        this((EntityType)ModEntities.GAPING_VOID.get(), level);
        this.setUser(shooter);
    }

    public static double getVoidScale(double age) {
        double life = age / 186.0;
        double curve = life < collapse ? 0.005 + GapingVoidEntity.ease(1.0 - (collapse - life) / collapse) * 0.995 : GapingVoidEntity.ease(1.0 - (life - collapse) / (1.0 - collapse));
        return 10.0 * curve;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    public void setUser(LivingEntity user) {
        this.user = user;
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE_PARAMETER);
    }

    private void setAge(int age) {
        this.f_19804_.m_135381_(AGE_PARAMETER, (Object)age);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(AGE_PARAMETER, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setAge(tag.m_128451_("age"));
        if (this.m_9236_() instanceof ServerLevel) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.m_9236_()), (GameProfile)Const.AVARITIA_FAKE_PLAYER);
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("age", this.getAge());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        BlockPos position = this.m_20097_();
        int age = this.getAge();
        if (age >= 186 && !this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, posX, posY, posZ, 6.0f, Level.ExplosionInteraction.BLOCK);
            int range = 4;
            AABB axisAlignedBB = new AABB(position.m_7918_(-range, -range, -range), position.m_7918_(range, range, range));
            List nommed = this.m_9236_().m_6443_(Entity.class, axisAlignedBB, COMNOM_PREDICATE);
            nommed.stream().filter(entity -> entity != this).forEach(entity -> {
                if (entity instanceof EnderDragon) {
                    EnderDragon dragon = (EnderDragon)entity;
                    dragon.m_31120_(dragon.f_31080_, ModDamageTypes.causeRandomDamage(this.m_9236_(), (Entity)this.user), 1000.0f);
                    dragon.m_21153_(0.0f);
                } else if (entity instanceof WitherBoss) {
                    WitherBoss wither = (WitherBoss)entity;
                    wither.m_31510_(0);
                    wither.m_6469_(ModDamageTypes.causeRandomDamage(this.m_9236_(), (Entity)this.user), 1000.0f);
                } else {
                    entity.m_6469_(ModDamageTypes.causeRandomDamage(this.m_9236_(), (Entity)this.user), 1000.0f);
                }
            });
            this.m_142687_(Entity.RemovalReason.KILLED);
        } else {
            if (age == 0) {
                this.m_9236_().m_6263_((Player)this.fakePlayer, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.GAPING_VOID, SoundSource.HOSTILE, 8.0f, 1.0f);
            }
            this.setAge(age + 1);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.fakePlayer == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        for (int i = 0; i < 50; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), this.f_19796_.m_188583_() * 3.0, this.f_19796_.m_188583_() * 3.0, this.f_19796_.m_188583_() * 3.0);
        }
        double particlespeed = 4.5;
        double size = GapingVoidEntity.getVoidScale(age) * 0.5 - 0.2;
        int range = (int)(size * suckRange);
        AABB axisAlignedBB = new AABB(position.m_7918_(-range, -range, -range), position.m_7918_(range, range, range));
        List sucked = this.m_9236_().m_6443_(Entity.class, axisAlignedBB, SUCK_PREDICATE);
        double radius = GapingVoidEntity.getVoidScale(age) * 0.5;
        for (Entity suckee : sucked) {
            if (suckee == this) continue;
            double dx = posX - suckee.m_20185_();
            double dy = posY - suckee.m_20186_();
            double dz = posZ - suckee.m_20189_();
            double lensquared = dx * dx + dy * dy + dz * dz;
            double len = Math.sqrt(lensquared);
            double lenn = len / suckRange;
            if (!(len <= suckRange)) continue;
            double strength = (1.0 - lenn) * (1.0 - lenn);
            double power = 0.075 * radius;
            Vec3 motion = suckee.m_20184_();
            double motionX = motion.f_82479_ + dx / len * strength * power;
            double motionY = motion.f_82480_ + dy / len * strength * power;
            double motionZ = motion.f_82481_ + dz / len * strength * power;
            suckee.m_20334_(motionX, motionY, motionZ);
        }
        int nomrange = (int)(radius * 0.95);
        AABB alignedBB = new AABB(position.m_7918_(-nomrange, -nomrange, -nomrange), position.m_7918_(nomrange, nomrange, nomrange));
        List nommed = this.m_9236_().m_6443_(Entity.class, alignedBB, COMNOM_PREDICATE);
        for (Entity nommee : nommed) {
            if (nommee == this) continue;
            Vec3 nomedPos = nommee.m_20154_();
            Vec3 diff = this.m_20154_().m_82546_(nomedPos);
            double len = diff.m_82553_();
            if (!(len <= (double)nomrange)) continue;
            if (nommee instanceof EnderDragon) {
                EnderDragon dragon = (EnderDragon)nommee;
                dragon.m_31120_(dragon.f_31080_, this.m_269291_().m_269341_(), 5.0f);
            }
            nommee.m_6469_(this.m_269291_().m_269341_(), 5.0f);
        }
        if (age % 10 == 0) {
            Vec3 posFloor = this.m_20182_();
            int blockrange = Math.round(nomrange);
            for (int y = -blockrange; y <= blockrange; ++y) {
                for (int z = -blockrange; z <= blockrange; ++z) {
                    for (int x = -blockrange; x <= blockrange; ++x) {
                        float resist;
                        double dist;
                        Vec3 pos2 = new Vec3((double)x, (double)y, (double)z);
                        Vec3 rPos = posFloor.m_82549_(pos2);
                        BlockPos blockPos = BlockPos.m_274561_((double)rPos.f_82479_, (double)rPos.f_82480_, (double)rPos.f_82481_);
                        if (blockPos.m_123342_() < 0 || blockPos.m_123342_() > 255 || !((dist = pos2.m_82556_()) <= (double)nomrange) || this.m_9236_().m_8055_(blockPos).m_60795_()) continue;
                        BlockState state = this.m_9236_().m_8055_(blockPos);
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.m_9236_(), blockPos, state, (Player)this.fakePlayer);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled() || !((double)(resist = state.m_60734_().m_7325_()) <= 10.0)) continue;
                        state.m_60734_().canDropFromExplosion(state, (BlockGetter)this.m_9236_(), blockPos, new Explosion(this.m_9236_(), null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 6.0f, false, Explosion.BlockInteraction.DESTROY));
                        this.m_9236_().m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                    }
                }
            }
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6783_(double p_19883_) {
        return true;
    }
}

