/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.init.registry.ModEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TNTProEntity
extends ThrowableItemProjectile
implements TraceableEntity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(PrimedTnt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DEFAULT_FUSE_TIME = 80;
    @Nullable
    private LivingEntity owner;

    public TNTProEntity(EntityType<? extends TNTProEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public TNTProEntity(Level pLevel, double pX, double pY, double pZ, @Nullable LivingEntity pOwner) {
        this((EntityType<? extends TNTProEntity>)((EntityType)ModEntities.tntProEntity.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
        double d = pLevel.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        this.setFuse(80);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
        this.owner = pOwner;
    }

    protected Item m_7881_() {
        return Blocks.f_50077_.m_5456_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.explodeAndRemove();
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        this.explodeAndRemove();
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        Vec3 currentPos = this.m_20182_();
        Vec3 nextPos = currentPos.m_82549_(this.m_20184_());
        BlockHitResult blockhitresult = this.m_9236_().m_45547_(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockhitresult.m_6662_() != HitResult.Type.MISS) {
            this.m_8060_(blockhitresult);
            return;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        if (!this.m_9236_().f_46443_) {
            List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> !(entity instanceof TNTProEntity) && entity.m_6087_());
            for (Entity entity2 : list) {
                if (entity2 == this.getOwner()) continue;
                this.m_5790_(new EntityHitResult(entity2));
                return;
            }
        }
        int fuse = this.getFuse() - 1;
        this.setFuse(fuse);
        if (fuse <= 0) {
            this.explodeAndRemove();
        } else {
            this.m_20073_();
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void explode() {
        float f = 4.0f;
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 4.0f, Level.ExplosionInteraction.TNT);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void explodeAndRemove() {
        if (!this.m_9236_().f_46443_) {
            this.explode();
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128376_("Fuse", (short)this.getFuse());
    }

    public void m_7378_(CompoundTag pCompound) {
        this.setFuse(pCompound.m_128448_("Fuse"));
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return 0.15f;
    }

    public void setFuse(int pLife) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)pLife);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }
}

