/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideConfigurationCardItem
extends Item {
    public SideConfigurationCardItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(ModRarities.RARE));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("SideConfig")) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.has_config"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.instruction_right_click"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.no_config"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.instruction_shift_right_click"));
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.instruction_shift_air"));
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (player == null || level.m_5776_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (player.m_6144_()) {
            if (blockEntity instanceof ITileIO) {
                ITileIO tileIO = (ITileIO)blockEntity;
                if (!stack.m_41783_().m_128441_("SideConfig")) {
                    SideConfiguration config = tileIO.getSideConfiguration();
                    this.saveConfigToItem(stack, config);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.read_success"), true);
                    return InteractionResult.SUCCESS;
                }
                SideConfiguration config = this.loadConfigFromItem(stack);
                tileIO.setSideConfiguration(config);
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.apply_success"), true);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41782_()) {
                if (stack.m_41783_().m_128441_("SideConfig")) {
                    stack.m_41783_().m_128473_("SideConfig");
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.cleared"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.avaritia.side_config_card.already_empty"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void saveConfigToItem(ItemStack stack, SideConfiguration config) {
        stack.m_41784_().m_128365_("SideConfig", (Tag)config.toNBT());
    }

    private SideConfiguration loadConfigFromItem(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("SideConfig")) {
            return new SideConfiguration();
        }
        return SideConfiguration.fromNBT(stack.m_41783_().m_128469_("SideConfig"));
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("SideConfig");
    }
}

