/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.blaze;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.common.entity.arrow.BurningArrowEntity;
import committee.nova.mods.avaritia.common.entity.ball.BurningBallEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeBowItem
extends BowItem
implements ITooltip,
ISwitchable,
IBowTransform {
    public BlazeBowItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(ModRarities.EPIC).m_41486_());
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    @Override
    public boolean hasDescTooltip() {
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        if (player.m_6144_()) {
            this.switchMode(level, player, hand, "blaze_bow_burning");
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int drawTime = this.m_8105_(stack) - timeLeft;
            if ((drawTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (boolean)true)) < 0) {
                return;
            }
            float VELOCITY_MULTIPLIER = 1.2f;
            float DAMAGE_MULTIPLIER = 2.0f;
            float draw = BlazeBowItem.m_40661_((int)drawTime);
            float powerForTime = draw * VELOCITY_MULTIPLIER;
            if ((double)powerForTime >= 0.1) {
                if (!level.f_46443_) {
                    if (this.isActive(stack, "blaze_bow_burning")) {
                        BurningBallEntity burningBall = (BurningBallEntity)((EntityType)ModEntities.BURNING_BALL.get()).m_20615_(level);
                        if (burningBall != null) {
                            burningBall.m_5602_((Entity)player);
                            burningBall.m_6034_(player.m_20185_(), player.m_20188_() + 0.1, player.m_20189_());
                            burningBall.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, powerForTime * 3.0f, 0.5f);
                            level.m_7967_((Entity)burningBall);
                            player.m_36335_().m_41524_(stack.m_41720_(), 20);
                        }
                    } else {
                        AbstractArrow abstractarrow = this.customArrow((AbstractArrow)new BurningArrowEntity((Entity)player));
                        abstractarrow = this.customArrow(abstractarrow);
                        abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, powerForTime * 3.0f, 0.5f);
                        if (draw == 1.0f) {
                            abstractarrow.m_36762_(true);
                        }
                        abstractarrow.m_36781_(abstractarrow.m_36789_() * (double)DAMAGE_MULTIPLIER);
                        this.addEnchant(stack, level, (LivingEntity)player, abstractarrow, powerForTime);
                        level.m_7967_((Entity)abstractarrow);
                    }
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.isActive(stack, "blaze_bow_burning") ? SoundEvents.f_12473_ : SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f) + powerForTime * 0.5f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    private void addEnchant(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity player, AbstractArrow arrowEntity, float powerForTime) {
        int k;
        int j = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (j > 0) {
            arrowEntity.m_36781_(arrowEntity.m_36789_() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            arrowEntity.m_36735_(k);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrowEntity.m_20254_(100);
        }
        stack.m_41622_(1, player, livingEntity -> livingEntity.m_21190_(player.m_7655_()));
        arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
    }
}

