/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import committee.nova.mods.avaritia.common.entity.arrow.NeutronArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class CrystalBowItem
extends BowItem
implements ISwitchable,
IBowTransform {
    public CrystalBowItem() {
        super(new Item.Properties().m_41497_(ModRarities.EPIC).m_41487_(1).m_41486_());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.switchMode(pLevel, player, hand, "blade_slash");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(pLevel, player, hand);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            boolean isBladeSlashActive = this.isActive(pStack, "blade_slash");
            boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)pStack) > 0;
            ItemStack ammo = player.m_6298_(pStack);
            int chargeTime = this.m_8105_(pStack) - pTimeLeft;
            if ((chargeTime = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)chargeTime, (!ammo.m_41619_() || hasInfinity ? 1 : 0) != 0)) < 0) {
                return;
            }
            float power = CrystalBowItem.m_40661_((int)chargeTime);
            if ((double)power >= 0.1) {
                if (!pLevel.f_46443_) {
                    if (isBladeSlashActive) {
                        BladeSlashEntity bladeSlash = new BladeSlashEntity(pLevel, (LivingEntity)player);
                        float speed = BladeSlashEntity.defaultSpeed * (1.0f + power * 2.0f);
                        float inaccuracy = 0.5f - power * 0.4f;
                        float yawOffset = 0.0f;
                        bladeSlash.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + yawOffset, 0.0f, speed, inaccuracy);
                        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)pStack);
                        float damageBoost = (float)powerLevel * 1.2f + power * 5.0f;
                        bladeSlash.damage += damageBoost;
                        bladeSlash.duration += (int)(power * 20.0f);
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)pStack) > 0) {
                            bladeSlash.m_20254_(100);
                        }
                        pLevel.m_7967_((Entity)bladeSlash);
                        pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.8f + power * 0.4f);
                    } else {
                        NeutronArrowEntity neutronArrow = new NeutronArrowEntity((EntityType<? extends Arrow>)((EntityType)ModEntities.NEUTRON_ARROW.get()), pLevel);
                        neutronArrow.m_5602_((Entity)player);
                        neutronArrow.m_6034_(player.m_20185_(), player.m_20188_() - (double)0.1f, player.m_20189_());
                        float speed = 3.0f;
                        float inaccuracy = 0.0f;
                        float yawOffset = 0.0f;
                        neutronArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + yawOffset, 0.0f, speed, inaccuracy);
                        pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 0.8f + power * 0.4f);
                        pLevel.m_7967_((Entity)neutronArrow);
                    }
                    pStack.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(player.m_7655_()));
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public void m_7836_(ItemStack stack, @NotNull Level level, @NotNull Player player) {
        stack.m_41663_(Enchantments.f_44952_, 1);
        stack.m_41663_(Enchantments.f_44959_, 1);
        super.m_7836_(stack, level, player);
    }
}

