/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityAxeItem
extends AxeItem
implements ISwitchable,
IUndamageable {
    public InfinityAxeItem() {
        super(ModToolTiers.INFINITY, 100.0f, -50.0f, new Item.Properties().m_41497_(ModRarities.COSMIC).m_41487_(1).m_41486_());
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.switchMode(pLevel, player, hand, "infinity_axe_range");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(pLevel, player, hand);
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isActive(stack, "infinity_axe_range") && ToolUtils.canHarvest(pos, (Level)serverLevel) && miningEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)miningEntity;
                ToolUtils.destroyTree((Player)player, serverLevel, pos, state);
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        ServerPlayer livingEntity;
        Level level;
        if (entity instanceof ServerPlayer && !(level = (livingEntity = (ServerPlayer)entity).m_9236_()).m_5776_() && livingEntity.m_6117_() && livingEntity.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            ItemStack shieldStack = livingEntity.m_21211_();
            ShieldItem shieldItem = (ShieldItem)shieldStack.m_41720_();
            boolean isInfinityShield = shieldStack.m_150930_((Item)ModItems.infinity_shield.get());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (isInfinityShield) {
                return true;
            }
            livingEntity.m_5810_();
            if (shieldStack.m_41773_() >= shieldStack.m_41776_() - 1) {
                livingEntity.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            } else {
                shieldStack.m_41721_(shieldStack.m_41776_() - 1);
            }
            livingEntity.m_36335_().m_41524_((Item)shieldItem, 1200);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43314_().m_6631_(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.m_43314_().m_6624_(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

