/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenArrowEntity;
import committee.nova.mods.avaritia.common.entity.arrow.TraceArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityBowItem
extends BowItem
implements ISwitchable,
InitEnchantItem,
IUndamageable,
IBowTransform {
    public InfinityBowItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(ModRarities.COSMIC).m_41486_());
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_8120_(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 99;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 1200;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44952_ ? 10 : 0;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)ModTooltips.INIT_ENCHANT.args(Enchantments.f_44952_.m_44700_(10)).build());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        if (player.m_6144_()) {
            this.switchMode(level, player, hand, "infinity_bow_tracer");
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            int drawTime = this.m_8105_(stack) - timeLeft;
            if ((drawTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (boolean)true)) < 0) {
                return;
            }
            float VELOCITY_MULTIPLIER = 1.2f;
            float DAMAGE_MULTIPLIER = 5000.0f;
            float draw = InfinityBowItem.m_40661_((int)drawTime);
            float powerForTime = draw * VELOCITY_MULTIPLIER;
            AbstractArrow arrowEntity = this.customArrow((AbstractArrow)new HeavenArrowEntity((Entity)player));
            if (this.isActive(stack, "infinity_bow_tracer") && (double)powerForTime >= 0.1) {
                arrowEntity = this.customArrow((AbstractArrow)new TraceArrowEntity((Entity)player));
            }
            arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, powerForTime * 3.0f, 0.01f);
            if (draw == 1.0f) {
                arrowEntity.m_36762_(true);
            }
            arrowEntity.m_36781_(arrowEntity.m_36789_() * (double)DAMAGE_MULTIPLIER);
            this.addEnchant(stack, level, (LivingEntity)player, arrowEntity, powerForTime);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f) + powerForTime * 0.5f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    private void addEnchant(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity player, AbstractArrow arrowEntity, float powerForTime) {
        int k;
        int j = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (j > 0) {
            arrowEntity.m_36781_(arrowEntity.m_36789_() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            arrowEntity.m_36735_(k);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrowEntity.m_20254_(100);
        }
        stack.m_41622_(1, player, livingEntity -> livingEntity.m_21190_(player.m_7655_()));
        arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        level.m_7967_((Entity)arrowEntity);
    }
}

